% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AggPeps.R
\name{AggPeps}
\alias{AggPeps}
\title{Aggregate peptide abundance values}
\usage{
AggPeps(
  dat,
  pep_mapping_tbl,
  method = c("sum", "robreg"),
  logged = c(TRUE, FALSE)
)
}
\arguments{
\item{dat}{a dataframe or matrix of peptide abundance, or a SummarizedExperiment object where
grouping and peptide-protein mapping are provided in colData and rowData, respectively.}

\item{pep_mapping_tbl}{a table mapping peptides to proteins. Alternatively, it can be the
column name of the protein in rowData if dat is a SummarizedExperiment object.}

\item{method}{method of aggregation. Options including "sum" (summed peptide intensity)
and "robreg" (robust regression with M-Estimation).}

\item{logged}{Boolean variable indicating whether abundance data have been
log-transformed}
}
\value{
\code{AggPeps} returns a list containing a matrix of protein abundance values and a vector of number of peptides
}
\description{
Given peptide abundance and assignment of peptide sequences to proteins,
aggregate peptide abundance values into protein abundance values.
}
\examples{
# Generate random peptide data
dat <- 2^matrix(rnorm(3000), ncol = 6)
colnames(dat) <- paste0("Sample", 1:6)
rownames(dat) <- paste0("Peptide", 1:500)

# Generate peptide mapping table
pep_mapping_tbl <- data.frame(peptide = paste0("Peptide", 1:500),
protein = paste0("Protein", rep(1:100, each = 5)))

AggPeps(dat, pep_mapping_tbl, method = "sum",
logged = FALSE)

# Store data as a SummarizedExperiment object
library(tibble)
library(SummarizedExperiment)
rowData <- pep_mapping_tbl |> column_to_rownames(var = "peptide")
dat.nn <- dat
rownames(dat.nn) <- NULL
colnames(dat.nn) <- NULL
dat.se <- SummarizedExperiment(assays = list(int = dat.nn), rowData = rowData)

AggPeps(dat.se, pep_mapping_tbl = "protein", method = "sum",
logged = FALSE)

}
\author{
Junmin Wang
}
