% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_health_sel.R
\name{health_sel_ui}
\alias{health_sel_ui}
\alias{health_sel_server}
\alias{health_sel_demo}
\title{Shiny module to select a health variable in a pedigree}
\usage{
health_sel_ui(id)

health_sel_server(
  id,
  pedi,
  var = NULL,
  as_num = NULL,
  mods_aff = NULL,
  threshold = NULL,
  sup_threshold = NULL
)

health_sel_demo()
}
\arguments{
\item{id}{A string to identify the module.}

\item{pedi}{A reactive pedigree object.}

\item{var}{A string with the name of the health variable to select.}

\item{as_num}{A boolean to know if the health variable needs to be considered
as numeric.}

\item{mods_aff}{A character vector of the affected modalities.}

\item{threshold}{A numeric threshold to determine affected individuals.}

\item{sup_threshold}{A boolean to know if the affected individuals
are strickly superior to the threshold.}
}
\value{
A reactive list with the following informations:\code{actions-box}
\itemize{
\item health_var: the selected health variable,
\item to_num: a boolean to know if the health variable needs to be considered as
numeric,
\item mods_aff: a character vector of the affected modalities,
\item threshold: a numeric threshold to determine affected individuals,
\item sup_threshold: a boolean to know if the affected individuals are strickly
superior to the threshold.
}
}
\description{
This module allows to select health variables in a pedigree object.
The function is composed of two parts: the UI and the server.
The UI is called with the function \code{health_sel_ui()} and the server
with the function \code{health_sel_server()}.
}
\examples{
if (interactive()) {
    health_sel_demo()
}
}
\keyword{internal}
