% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeacoQC.R
\name{RemoveDoublets}
\alias{RemoveDoublets}
\title{Remove doublet events from flow cytometry data}
\usage{
RemoveDoublets(ff, channel1="FSC-A", channel2="FSC-H", nmad=4,
verbose=FALSE, output="frame")
}
\arguments{
\item{ff}{A flowframe that contains flow cytometry data.}

\item{channel1}{The first channels that will be used to determine the
doublet events. Default is "FSC-A"}

\item{channel2}{The second channels that will be used to determine the
doublet events. Default is "FSC-H"}

\item{nmad}{Bandwidth above the ratio allowed (cells are kept if their
ratio is smaller than the median ratio + \code{nmad} times the median
absolute deviation of the ratios). Default is 4.}

\item{verbose}{If set to TRUE, the median ratio and width will be printed.
Default is FALSE.}

\item{output}{If set to "full", a list with the filtered flowframe and the
indices of the doublet event is returned. If set to "frame", only the
filtered flowframe is returned. The default is "frame".}
}
\value{
This function returns either a filtered flowframe when the
\code{output} parameter is set to "frame" or a list containing the filtered
flowframe and a TRUE/FALSE list indicating the margin events. An extra column
named "Original_ID" is added to the flowframe where the cells are given their
original cell id.
}
\description{
\code{RemoveDoublets} will remove doublet events from the
flowframe based on two channels.
}
\examples{
# Read in data
fileName <- system.file("extdata", "111.fcs", package="PeacoQC")
ff <- flowCore::read.FCS(fileName)

# Remove doublets
ff_cleaned <- RemoveDoublets(ff)
}
