% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeacoQC.R
\name{PlotPeacoQC}
\alias{PlotPeacoQC}
\title{Visualise deleted cells of PeacoQC}
\usage{
PlotPeacoQC(ff, channels, output_directory=".", display_cells=2000,
            manual_cells=NULL, title_FR=NULL, display_peaks=TRUE,
            prefix="PeacoQC_", time_unit=100, time_channel_parameter="Time",
             ...)
}
\arguments{
\item{ff}{A flowframe}

\item{channels}{Indices of names of the channels in the flowframe that have
to be displayed}

\item{output_directory}{Directory where the plots should be generated. Set
to NULL if no plots need to be generated. The default is the working
directory.}

\item{display_cells}{The number of measurements that should be displayed.
(The number of dots that are displayed for every channel) The default is
2000.}

\item{manual_cells}{Give a vector (TRUE/FALSE) with annotations for each cell
to compare the automated QC with. The default is NULL.}

\item{title_FR}{The title that has to be displayed above the flow rate
figure. Default is NULL.}

\item{display_peaks}{If the result of \code{PeacoQC} is given, all the
quality control results will be visualised. If set to TRUE: \code{PeacoQC}
will be run and only the peaks will be displayed without any quality control.
If set to FALSE, no peaks will be displayed and only the events will be
displayed. Default is TRUE.}

\item{prefix}{The prefix that will be given to the generated png file.
Default is "PeacoQC_".}

\item{time_unit}{The number of time units grouped together for visualising
event rate. The default is set to 100, resulting in events per second for
most flow datasets. Suggested to adapt for mass cytometry data.}

\item{time_channel_parameter}{Name of the time channel in ff if present.
Default is "Time".}

\item{...}{Arguments to be given to \code{PeacoQC} if \code{display_peaks}
is set to TRUE.}
}
\value{
This function returns nothing but generates a png file in the
output_directory
}
\description{
\code{PlotPeacoQC} will generate a png file with on overview of
the flow rate and the different selected channels. These will be annotated
based on the measurements that were removed by PeacoQC. It is also possible
to only display the quantiles and median or only the measurements without
any annotation.
}
\examples{

## Plotting the results of PeacoQC

# Read in transformed and compensated data
fileName <- system.file("extdata", "111_Comp_Trans.fcs", package="PeacoQC")
ff <- flowCore::read.FCS(fileName)

# Define channels on which the quality control should be done and the
# plots should be made
channels <- c(1, 3, 5:14, 18, 21)

# Run PeacoQC
PeacoQC_res <- PeacoQC(ff,
    channels,
    determine_good_cells="all",
    plot=FALSE,
    save_fcs=TRUE)

# Run PlotPeacoQC
PlotPeacoQC(ff, channels, display_peaks=PeacoQC_res)

## Plot only the peaks (No quality control)
PlotPeacoQC(ff, channels, display_peaks=TRUE)

## Plot only the dots of the file
PlotPeacoQC(ff, channels, display_peaks=FALSE)

}
