% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappingPathwaysClusters.R
\name{mappingPathwaysClusters}
\alias{mappingPathwaysClusters}
\title{Outputs a table with pathways and their respective clusters}
\usage{
mappingPathwaysClusters(
  pcxn,
  dePathways,
  clusteringFunction = NULL,
  edgeFDR = 0.05,
  correlationCutOff = 0.316,
  pathwayFDR = 0.05,
  topPathways = 200,
  plotOut = TRUE,
  subplot = TRUE,
  topClusters = 2,
  prefix = "",
  outDir = ".",
  saveNameCSV = NULL,
  weighted = FALSE
)
}
\arguments{
\item{pcxn}{pathways network (edge list of pathways)}

\item{dePathways}{differential expressed pathways, obtained from
*DifferentialPathwayAnalysis*}

\item{clusteringFunction}{clustering algorithm}

\item{edgeFDR}{FDR threshold for pathway-pathway adjusted p-values;
filter edges with adjusted p-values less than given threshold}

\item{correlationCutOff}{cut-off threshold for pathway-pathway correlation;
filter pathways with correlation less than given threshold}

\item{pathwayFDR}{FDR threshold for DE pathways adjusted p-values;
filter pathways with adjusted p-values less than given threshold}

\item{topPathways}{use only top x paths; if NULL, use all paths}

\item{plotOut}{if TRUE, store graph plot in Figures directory of plots}

\item{subplot}{if TRUE, store individual clusters plots and connected plots
in Figures directory of plots}

\item{topClusters}{plot figures for top x clusters}

\item{prefix}{add prefix to plots}

\item{outDir}{output directory}

\item{saveNameCSV}{if not NULL, saves output as csv using save name}

\item{weighted}{True if you wish to include correlation weights in clustering}
}
\value{
a list where the first item is a table with each row containing
  a pathway and its respective cluster. The second item is an igraph object.
}
\description{
Outputs a table with pathways and their respective clusters
}
\examples{
data("miniTestsPanomiR")

mappingPathwaysClusters(pcxn = miniTestsPanomiR$miniPCXN,
                         dePathways = miniTestsPanomiR$miniDEP,
                         topPathways = 200,
                         outDir=".",
                         plot = FALSE,
                         subplot = FALSE,
                         prefix='',
                         clusteringFunction = "cluster_louvain",
                         correlationCutOff = 0.1)

}
