% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragments-calculate.R
\name{calculateFragments}
\alias{calculateFragments}
\alias{modificationPositions}
\alias{defaultNeutralLoss}
\alias{calculateFragments,character,missing-method}
\title{Calculate ions produced by fragmentation with variable modifications}
\usage{
\S4method{calculateFragments}{character,missing}(
  sequence,
  type = c("b", "y"),
  z = 1,
  fixed_modifications = c(C = 57.02146),
  variable_modifications = numeric(),
  max_mods = Inf,
  neutralLoss = defaultNeutralLoss(),
  verbose = TRUE,
  modifications = NULL
)
}
\arguments{
\item{sequence}{\code{character()} providing a peptide sequence.}

\item{type}{\code{character} vector of target ions; possible values:
\code{c("a", "b", "c", "x", "y", "z")}. Default is \code{type = c("b", "y")}.}

\item{z}{numeric with a desired charge state; default is 1.}

\item{fixed_modifications}{A named \code{numeric} vector of used fixed modifications.
The name must correspond to the one-letter-code of the modified amino acid
and the numeric value must represent the mass that should be added to the
original amino accid mass, default: Carbamidomethyl modifications =
c(C = 57.02146). Use Nterm or Cterm as names for modifications that should
be added to the amino respectively carboxyl-terminus.}

\item{variable_modifications}{A named \code{numeric} vector of variable modifications.
Depending on the maximum number of modifications (\code{max_mods}), all possible
combinations are returned.}

\item{max_mods}{A numeric indicating the maximum number of variable modifications
allowed on the sequence at once. Does not include fixed modifications.
Default value is positive infinity.}

\item{neutralLoss}{\code{list}, it has to have two named elments,
namely \code{water} and \code{ammonia} that contain a \code{character} vector
which type of neutral loss should be calculated.  Currently
neutral loss on the C terminal \code{"Cterm"}, at the amino acids
\code{c("D", "E", "S", "T")} for \code{"water"} (shown with an \verb{_}) and
\code{c("K", "N", "Q", "R")} for \code{"ammonia"} (shown with an \code{*}) are
supported.

\if{html}{\out{<div class="sourceCode">}}\preformatted{There is a helper function `defaultNeutralLoss()` that returns
the correct list. It has two arguments `disableWaterLoss` and
`disableAmmoniaLoss` to remove single neutral loss options. See
the example section for use cases.
}\if{html}{\out{</div>}}}

\item{verbose}{\code{logical(1)}. If \code{TRUE} (default) the used modifications are printed.}

\item{modifications}{Named \code{numeric()}. Deprecated modifications parameter.
Will override \code{fixed_modifications} but is set to \code{NULL} by default. Please
refrain from using it, opt for \code{fixed_modifications} instead.}
}
\value{
A \code{data.frame} showing all the
ions produced by fragmentation with all possible combinations of modifications.
The used variable modifications are displayed in the \code{peptide} column through the
use of amino acids followed by the modification within brackets.
Fixed modifications are not displayed.
}
\description{
This method calculates a-, b-, c-, x-, y- and z-ions produced by
fragmentation.

Available methods
\itemize{
\item The default method with signature \code{sequence = "character"} and
\code{object = "missing"} calculates the theoretical fragments for a
peptide sequence. It returns a \code{data.frame} with the columns
\code{mz}, \code{ion}, \code{type}, \code{pos}, \code{z}, \code{seq} and \code{peptide}.
\item Additional method can be defined that will adapt their behaviour
based on spectra defined in \code{object}. See for example the MSnbase
package that implements a method for objects of class
\code{Spectrum2}.
}
}
\examples{
## General use
calculateFragments(sequence = "ARGSHKATC",
                   type = c("b", "y"), z = 1,
                   fixed_modifications = c(C = 57),
                   variable_modifications = c(S = 79, Y = 79, T = 79),
                   max_mods = 2)

## calculate fragments for ACE with default modification
calculateFragments("ACE", fixed_modifications = c(C = 57.02146))

#' ## calculate fragments for ACE with an added variable modification
calculateFragments("ACE", variable_modifications = c(A = 43.25))

## calculate fragments for ACE with an added N-terminal modification
calculateFragments("ACE", fixed_modifications = c(C = 57.02146, Nterm = 229.1629))

## calculate fragments for ACE without any modifications
calculateFragments("ACE", fixed_modifications = NULL)

calculateFragments("VESITARHGEVLQLRPK",
                   type = c("a", "b", "c", "x", "y", "z"),
                   z = 1:2)

## neutral loss
defaultNeutralLoss()

## disable water loss on the C terminal
defaultNeutralLoss(disableWaterLoss="Cterm")

## real example
calculateFragments("PQR")
calculateFragments("PQR",
                   neutralLoss=defaultNeutralLoss(disableWaterLoss="Cterm"))
calculateFragments("PQR",
                   neutralLoss=defaultNeutralLoss(disableAmmoniaLoss="Q"))

## disable neutral loss completely
calculateFragments("PQR", neutralLoss=NULL)

}
\author{
Sebastian Gibb \href{mailto:mail@sebastiangibb.de}{mail@sebastiangibb.de}

Guillaume Deflandre \href{mailto:guillaume.deflandre@uclouvain.be}{guillaume.deflandre@uclouvain.be}
}
