% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizationPlots.R
\name{plot_intragroup_PEV}
\alias{plot_intragroup_PEV}
\title{Plot intragroup pooled estimate of variance (PEV) of the normalized data}
\usage{
plot_intragroup_PEV(se, ain = NULL, condition = NULL, diff = FALSE)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{ain}{Vector of strings which assay should be used as input (default NULL).
If NULL then all normalization of the se object are plotted next to each other.}

\item{condition}{column name of condition (if NULL, condition saved in SummarizedExperiment will be taken)}

\item{diff}{Boolean indicating whether to visualize the reduction of intragroup variation (PEV) compared to "log" (TRUE) or a normal boxplot of intragroup variation (PEV) for each normalization method (FALSE).}
}
\value{
ggplot object (boxplot)
}
\description{
Plot intragroup pooled estimate of variance (PEV) of the normalized data
}
\examples{
data(tuberculosis_TMT_se)
plot_intragroup_PEV(tuberculosis_TMT_se, ain = NULL,
                            condition = NULL, diff = FALSE)

}
