% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Enrichment.R
\name{plot_intersection_enrichment}
\alias{plot_intersection_enrichment}
\title{Functional enrichment analysis for analyzing the DE results of different normalization methods and biologically interpreting the results}
\usage{
plot_intersection_enrichment(
  se,
  de_res,
  comparison,
  ain = NULL,
  id_column = "Gene.Names",
  organism = "hsapiens",
  source = "KEGG",
  signif_thr = 0.05
)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{de_res}{data table resulting of run_DE}

\item{comparison}{String of comparison (must be a valid comparison saved in de_res)}

\item{ain}{Vector of strings of normalization methods to visualize (must be valid normalization methods saved in de_res)}

\item{id_column}{String specifying the column of the rowData of the SummarizedExperiment object which includes the gene names}

\item{organism}{Organism name (gprofiler parameter)}

\item{source}{Data source to use (gprofiler parameter, example: KEGG)}

\item{signif_thr}{Significance threshold}
}
\value{
list of ggplot objects
}
\description{
Functional enrichment analysis for analyzing the DE results of different normalization methods and biologically interpreting the results
}
\examples{
data(tuberculosis_TMT_se)
data(tuberculosis_TMT_de_res)
plot_intersection_enrichment(tuberculosis_TMT_se, tuberculosis_TMT_de_res,
                ain = c("IRS_on_Median", "IRS_on_RobNorm", "RobNorm"),
                comparison = "Rx-TBL", id_column = "Gene.Names",
                organism = "hsapiens", source = "GO:BP", signif_thr = 0.05)

}
