% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpikeDEPlots.R
\name{plot_TP_FP_spiked_bar}
\alias{plot_TP_FP_spiked_bar}
\title{Barplot of true and false positives for specific comparisons and normalization methods}
\usage{
plot_TP_FP_spiked_bar(stats, ain = NULL, comparisons = NULL)
}
\arguments{
\item{stats}{data table with multiple metrics of the DE results (resulting of get_spiked_stats_DE)}

\item{ain}{Vector of strings of normalization methods to visualize (must be valid normalization methods saved in stats)}

\item{comparisons}{Vector of comparisons (must be valid comparisons saved in stats)}
}
\value{
ggplot object (barplot)
}
\description{
Barplot of true and false positives for specific comparisons and normalization methods
}
\examples{
data(spike_in_se)
data(spike_in_de_res)
stats <- get_spiked_stats_DE(spike_in_se, spike_in_de_res)
plot_TP_FP_spiked_bar(stats, ain = NULL, comparisons = NULL)

}
