% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPOWSC.R
\name{runPOWSC}
\alias{runPOWSC}
\title{Estimate characterized parameters for a given scRNA-seq data (SingleCellExperiment object or a count matrix).}
\usage{
runPOWSC(
  sim_size = c(50, 100, 200, 800, 1000),
  per_DE = 0.05,
  est_Paras,
  DE_Method = c("MAST", "SC2P"),
  Cell_Type = c("PW", "Multi"),
  multi_Prob = NULL,
  alpha = 0.1,
  disc_delta = 0.1,
  cont_delta = 0.5
)
}
\arguments{
\item{sim_size}{a list of numbers}

\item{per_DE}{the percentage of the DE genes.}

\item{est_Paras}{the template parameter estimated from one cell type.}

\item{DE_Method}{is a string chosen from "MAST" or "SC2P".}

\item{Cell_Type}{is a string corresponding to the 1st scenario: same cell type comparison, and 2nd scenario: multiple cell types.}

\item{multi_Prob}{is the mixture cell proportions which sum up to 1. If not summing up to 1, then the package will internally do the normalization procedure.}

\item{alpha}{is the cutoff for the fdr which can be modified}

\item{disc_delta}{or the zero ratio change is the cutoff (=0.1) used to determined the high DE genes for Form II.}

\item{cont_delta}{or the lfc is the cutoff (=0.5) used to determined the high DE genes for Form II.}
}
\value{
POWSC object
}
\description{
These parameters include four gene-wise parameters and two cell-wise parameters.
}
\examples{
data("es_mef_sce")
sce = es_mef_sce[, colData(es_mef_sce)$cellTypes == "fibro"]
set.seed(12)
rix = sample(1:nrow(sce), 500)
sce = sce[rix, ]
est_Paras = Est2Phase(sce)
sim_size = c(100, 200) # A numeric vector
pow_rslt = runPOWSC(sim_size = sim_size, est_Paras = est_Paras,per_DE=0.05, DE_Method = "MAST", Cell_Type = "PW") # Note, using our previous developed tool SC2P is faster.
}
