% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaRankProd.R
\name{PomaRankProd}
\alias{PomaRankProd}
\title{Rank Product/Rank Sum Analysis}
\usage{
PomaRankProd(data, logged = TRUE, paired = NA, cutoff = 1, method = "pfp")
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{logged}{Logical. Indicates if data should be log transformed first.}

\item{paired}{Numeric. Indicates the number of random pairs generated in the function, if set to NA (default), the odd integer closer to the square of the number of replicates is used.}

\item{cutoff}{Numeric. Indicates the pfp/pvalue threshold value used to select features. Default is 1 to include all features.}

\item{method}{Character. Indicates the method to identify features. "pfp" uses percentage of false prediction, which is a default setting. "pval" uses p-values which is less stringent than pfp.}
}
\value{
A \code{list} with the results. Objects in the list are \code{up_regulated} (tibble) and \code{down_regulated} (tibble).
}
\description{
\code{PomaRankProd} performs the Rank Product (or Rank Sum) method to identify differentially expressed genes.
}
\examples{
data <- POMA::st000336 \%>\% # Example SummarizedExperiment object included in POMA
  PomaImpute()

## Output is a list with objects `up_regulated` (tibble with up regulated features) and `down_regulated` (tibble with down regulated features) 
## Perform on no-scaled object to avoid negative values
data \%>\% 
  PomaRankProd(method = "pfp")
}
\references{
Breitling, R., Armengaud, P., Amtmann, A., and Herzyk, P.(2004) Rank Products: A simple, yet powerful, new method to detect differentially regulated genes in replicated microarray experiments, FEBS Letter, 57383-92

Hong, F., Breitling, R., McEntee, W.C., Wittner, B.S., Nemhauser, J.L., Chory, J. (2006). RankProd: a bioconductor package for detecting differentially expressed genes in meta-analysis Bioinformatics. 22(22):2825-2827

Del Carratore, F., Jankevics, A., Eisinga, R., Heskes, T., Hong, F. & Breitling, R. (2017). RankProd 2.0: a refactored Bioconductor package for detecting differentially expressed features in molecular profiling datasets. Bioinformatics. 33(17):2774-2775
}
\author{
Pol Castellano-Escuder
}
