% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix2hm.R
\name{matrix2hm}
\alias{matrix2hm}
\title{Generate a heatmap from a matrix}
\usage{
matrix2hm(input, x = NULL, y = NULL)
}
\arguments{
\item{input}{A matrix containing the data to be visualized in the heatmap}

\item{x}{A character vector specifying the columns to highlight in the heatmap}

\item{y}{A character vector specifying the rows to highlight in the heatmap}
}
\value{
A heatmap with highlighted specified rows and columns
}
\description{
This function generates a heatmap using the `plotly` package.
The heatmap highlights specific rows and columns provided by the user, while the rest of the matrix is dimmed.
The function also adds grid lines to the heatmap for better readability.
}
\examples{
# Create a sample matrix with row and column names
mat <- matrix(c(1, 0, 1, 0), 2, 2)
colnames(mat) <- c("Col1", "Col2")
rownames(mat) <- c("Row1", "Row2")
heatmap <- matrix2hm(input = mat, x = "Col1", y = "Row1")
heatmap
}
