% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-ConsensusMetaclusteringModel.R
\name{ConsensusMetaclusteringModel}
\alias{ConsensusMetaclusteringModel}
\alias{ConMetaclustModel}
\title{Constructor for a \code{ConsensusClusterModel} Object.}
\usage{
ConsensusMetaclusteringModel(trainData, ..., randomSeed)
}
\arguments{
\item{trainData}{A \code{MultiAssayExperiment} or \code{SummarizedExperiment} containing
molecular data to be used for consensus clustering with
\code{ConsensusClusterPlus::ConsensusClusterPlus}}

\item{...}{Force subsequent parameters to be named. Not used.}

\item{randomSeed}{An \code{integer} randomSeed that will be passed to the
randomSeed parameter of the \code{ConsensusClusterPlus::ConsensusClusterPlus}
function when training the model.}
}
\value{
A \code{ConsensusMetaclusteringModel} object containing the training
data and ready to be trained.
}
\description{
Constructor for a \code{ConsensusClusterModel} Object.
}
\examples{
data(CSPC_MAE)
set.seed(1987)
conMetaclustModel <- ConsensusMetaclusteringModel(CSPC_MAE, randomSeed=1987)

}
\seealso{
\code{\link[ConsensusClusterPlus:ConsensusClusterPlus]{ConsensusClusterPlus::ConsensusClusterPlus}}
}
