% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_pathway_significance.R
\name{find_pathway_significance}
\alias{find_pathway_significance}
\title{Find Pathway Significance}
\usage{
find_pathway_significance(
  genes,
  pathways_file,
  gene_number_cutoff = 5,
  mode,
  sample_size = 1000,
  num_cores
)
}
\arguments{
\item{genes}{Genes from assign_SNPs_to_genes()}

\item{pathways_file}{A file containing the pathway IDs, their names, and the
genes in the pathway}

\item{gene_number_cutoff}{A cut-off for the minimum number of genes in a
pathway}

\item{mode}{increasing/decreasing}

\item{sample_size}{How many times to sample the effects data during random
sampling}

\item{num_cores}{The number of cores to use in parallelizing PAST}
}
\value{
Rugplots data
}
\description{
Find Pathway Significance
}
\examples{
example("assign_SNPs_to_genes")
demo_pathways_file = system.file("extdata", "pathways.txt.xz",
  package = "PAST", mustWork = TRUE)
rugplots_data <- find_pathway_significance(genes, demo_pathways_file, 5,
  "increasing", 1000, 2)
}
