% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CalcMV.R
\name{CalcMV}
\alias{CalcMV}
\title{Calculate estimated mean and variance of RNA-Seq data}
\usage{
CalcMV(Data, Sizes=NULL, NormData=FALSE, MeanCutLow=100, MeanCutHigh=NULL, ApproxVal=10^-6, Plot=TRUE)
}
\arguments{
\item{Data}{input data matrix; it should be a gene-by-sample or isoform-by sample matrix}

\item{Sizes}{The library size factor for each sample. the number of values in Sizes is expected to be the
same as the number of columns of Data. The library size factor will be estimated using the median
normalization method implemented in EBSeq if Sizes is specified as NULL.}

\item{NormData}{whether the data is already normalized. If NormData=TRUE, the specification of Sizes
will be ignored and no normalization will be applied.}

\item{MeanCutLow,MeanCutHigh}{we suggests the users to apply Oscope on genes with high mean and
high variance. By default, MeanCutLow is specified as 100, consequently only genes with mean > 100
will be used. The CalcMV function will fit a linear regression on log(variance)~log(mean) on these
genes. Genes with variance above this line are considered as the high mean high variance genes.
The upper bound of mean may be specified using MeanCutHigh. If both are specified as NULL, all of the genes
will be considered when fitting the regression.}

\item{ApproxVal}{Default is 10^-6. It is used to approximate the estimate of parameter q for genes/isoforms
whose estimated variance is less than estimated mean. q will be estimated using 1-ApproxVal}

\item{Plot}{if Plot = T, a mean-variance plot will be shown. The fitted line will be shown and the
selected genes will be marked in green.}
}
\value{
Output is a list with 6 sublists : Mean: estimated means of genes/isoforms; Var: estimated variances;
Median: estimated medians; GeneToUse: the high mean high variance genes (suggested input for Oscope);
Q: estimated q's (without apporximation); Q_mdf: estimated q's with approximations;
Phi_mdf: estimated overdispersion parameter (phi), with approximations.
}
\description{
Calculate estimated mean and variance of RNA-Seq data
}
\examples{
exp=matrix(rnorm(100,1000,10),ncol=10)
rownames(exp)=paste0("g",1:10)
CalcMV(exp)
}
\author{
Ning Leng
}

