% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot.R
\name{all_uniprots}
\alias{all_uniprots}
\title{A table with all UniProt records}
\usage{
all_uniprots(fields = "accession", reviewed = TRUE, organism = 9606L)
}
\arguments{
\item{fields}{Character vector of fields as defined by UniProt. For
possible values please refer to
\url{https://www.uniprot.org/help/return_fields}}

\item{reviewed}{Retrieve only reviewed (`TRUE`), only unreviewed (`FALSE`)
or both (`NULL`).}

\item{organism}{Character or integer: name or identifier of the organism.}
}
\value{
Data frame (tibble) with the requested UniProt entries and fields.
}
\description{
Retrieves a table from UniProt with all proteins for a certain organism.
}
\examples{
human_swissprot_entries <- all_uniprots(fields = 'id')
human_swissprot_entries
# # A tibble: 20,396 x 1
#    `Entry name`
#    <chr>
#  1 OR4K3_HUMAN
#  2 O52A1_HUMAN
#  3 O2AG1_HUMAN
#  4 O10S1_HUMAN
#  5 O11G2_HUMAN
# # . with 20,386 more rows
}
