% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remap.R
\name{remap_dorothea_download}
\alias{remap_dorothea_download}
\title{Downloads TF-target interactions from ReMap}
\usage{
remap_dorothea_download()
}
\value{
Data frame with TF-target relationships.
}
\description{
ReMap (\url{http://remap.univ-amu.fr/}) is a database of ChIP-Seq
experiments. It provides raw and merged peaks and CRMs (cis regulatory
motifs) with their associations to regulators (TFs). TF-target
relationships can be derived as it is written in Garcia-Alonso et al.
2019: "For ChIP-seq, we downloaded the binding peaks from ReMap and scored
the interactions between each TF and each gene according to the distance
between the TFBSs and the genes’ transcription start sites. We evaluated
different filtering strategies that consisted of selecting only the
top-scoring 100, 200, 500, and 1000 target genes for each TF."
(\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC6673718/#s1title}).
This function returns the top TF-target relationships as used in DoRothEA:
\url{https://github.com/saezlab/dorothea/blob/master/inst/scripts/02_chip_seq.R}).
}
\examples{
remap_interactions <- remap_dorothea_download()
remap_interactions
# # A tibble: 136,988 x 2
#    tf    target
#    <chr> <chr>
#  1 ADNP  ABCC1
#  2 ADNP  ABCC6
#  3 ADNP  ABHD5
#  4 ADNP  ABT1
#  5 ADNP  AC002066.1
# # . with 136,978 more rows

}
\seealso{
\code{\link{remap_tf_target_download}}
}
