% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosmos.R
\name{omnipath_for_cosmos}
\alias{omnipath_for_cosmos}
\title{OmniPath PPI for the COSMOS PKN}
\usage{
omnipath_for_cosmos(
  organism = 9606L,
  resources = NULL,
  datasets = NULL,
  interaction_types = NULL,
  id_types = c("uniprot", "genesymbol"),
  ...
)
}
\arguments{
\item{organism}{Character or integer: name or NCBI Taxonomy ID of the
organism.}

\item{resources}{Character: names of one or more resources. Correct spelling
is important.}

\item{datasets}{Character: one or more network datasets in OmniPath.}

\item{interaction_types}{Character: one or more interaction type}

\item{id_types}{Character: translate the protein identifiers to these ID
types. Each ID type results two extra columns in the output, for the
"source" and "target" sides of the interaction, respectively. The
default ID type for proteins is Esembl Gene ID, and by default UniProt
IDs and Gene Symbols are included. The UniProt IDs returned by the web
service are left intact, while the Gene Symbols are queried from
Ensembl. These Gene Symbols are different from the ones returned from
the web service, and match the Ensembl Gene Symbols used by other
components of the COSMOS PKN.}

\item{...}{Further parameters to \code{\link{omnipath_interactions}}.}
}
\value{
Data frame with the columns source, target and sign.
}
\description{
OmniPath PPI for the COSMOS PKN
}
\examples{
op_cosmos <- omnipath_for_cosmos()
op_cosmos

}
\seealso{
\itemize{
    \item{\code{\link{cosmos_pkn}}}
    \item{\code{\link{omnipath-interactions}}}
}
}
