% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_attrs.R
\name{extra_attr_values}
\alias{extra_attr_values}
\title{Possible values of an extra attribute}
\usage{
extra_attr_values(data, key)
}
\arguments{
\item{data}{An interaction data frame with \emph{extra_attrs} column.}

\item{key}{The name of an extra attribute.}
}
\value{
A vector, most likely character, with the unique values of the
    extra attribute occuring in the data frame.
}
\description{
Extracts all unique values of an extra attribute occuring in this data
frame.
}
\details{
Note, at the end we unlist the result, which means it works well
for attributes which are atomic vectors but gives not so useful result
if the attribute values are more complex objects. As the time of
writing this, no such complex extra attribute exist in OmniPath.
}
\examples{
op <- omnipath(fields = "extra_attrs")
extra_attr_values(op, SIGNOR_mechanism)

}
\seealso{
\itemize{
    \item{\code{\link{extra_attrs_to_cols}}}
    \item{\code{\link{has_extra_attrs}}}
    \item{\code{\link{with_extra_attrs}}}
    \item{\code{\link{filter_extra_attrs}}}
    \item{\code{\link{extra_attrs}}}
}
}
