% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{chalmers_gem_id_type}
\alias{chalmers_gem_id_type}
\title{Metabolite identifier type label used in Chalmers Sysbio GEM}
\usage{
chalmers_gem_id_type(label)
}
\arguments{
\item{label}{Character: an ID type label, as shown in the table at
\code{\link{translate_ids}}}
}
\value{
Character: the Chalmers GEM specific ID type label, or the input
    unchanged if it could not be translated (still might be a valid
    identifier name). These labels should be column names from the
    "metabolites.tsv" distributed with the GEMs.
}
\description{
Metabolite identifier type label used in Chalmers Sysbio GEM
}
\examples{
chalmers_gem_id_type("metabolicatlas")
# [1] "metsNoComp"

}
\seealso{
\itemize{
    \item{\code{\link{hmdb_id_type}}}
    \item{\code{\link{uniprot_id_type}}}
    \item{\code{\link{ensembl_id_type}}}
    \item{\code{\link{uploadlists_id_type}}}
}
}
