% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{chalmers_gem_id_mapping_table}
\alias{chalmers_gem_id_mapping_table}
\title{Metabolite ID translation tables from Chalmers Sysbio}
\usage{
chalmers_gem_id_mapping_table(to, from = "metabolicatlas", organism = "Human")
}
\arguments{
\item{to}{Character: type of ID to translate to, either label used
internally in this package, or a column name from "metabolites.tsv"
distributed by Chalmers Sysbio. NSE is supported.}

\item{from}{Character: type of ID to translate from, same format as "to".}

\item{organism}{Character or integer: name or identifier of the organism.
Supported taxons are 9606 (Homo sapiens), 10090 (Mus musculus),
10116 (Rattus norvegicu), 7955 (Danio rerio), 7227 (Drosophila
melanogaster) and 6239 (Caenorhabditis elegans).}
}
\value{
Tibble with two columns, "From" and "To", with the corresponding ID
  types.
}
\description{
Metabolite ID translation tables from Chalmers Sysbio
}
\examples{
chalmers_gem_id_mapping_table('metabolicatlas', 'hmdb')

}
