% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omixerSpecific.R
\name{omixerSpecific}
\alias{omixerSpecific}
\title{Sample List Regeneration}
\usage{
omixerSpecific(
  df,
  sampleId = "sampleId",
  block = "block",
  wells,
  div = "none",
  positional = FALSE,
  plateNum = 1,
  layout,
  mask = 0,
  techVars,
  randVars
)
}
\arguments{
\item{df}{Sample list}

\item{sampleId}{String specifying sample ID variable}

\item{block}{Paired sample identifier}

\item{wells}{Number of wells on a plate}

\item{div}{Plate subdivisions}

\item{positional}{Logical indicator of positional batch effects}

\item{plateNum}{Number of plates}

\item{layout}{Custom plate layout as data frame}

\item{mask}{Wells to be left empty}

\item{techVars}{Technical covariates}

\item{randVars}{Randomization variables}
}
\value{
Chosen layout as a data frame
}
\description{
Regenerate an Omixer-produced randomized sample list quickly,
after setting up the random environement from omixerRand
}
\examples{
library(tibble)
library(forcats)
library(stringr)

sampleList <- tibble(sampleId=str_pad(1:48, 4, pad="0"),
sex=as_factor(sample(c("m", "f"), 48, replace=TRUE)), 
age=round(rnorm(48, mean=30, sd=8), 0), 
smoke=as_factor(sample(c("yes", "ex", "never"), 48, replace=TRUE)),
date=sample(seq(as.Date('2008/01/01'), as.Date('2016/01/01'), 
               by="day"), 48))
               
randVars <- c("sex", "age", "smoke", "date")

omixerLayout <- omixerSpecific(sampleList, sampleId="sampleId", 
block="block", wells=48, div="row", 
plateNum=1, randVars=randVars)
}
