% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-counts.R
\docType{methods}
\name{normalizationFactors}
\alias{normalizationFactors}
\alias{normalizationFactors,OutriderDataSet-method}
\alias{normalizationFactors<-,OutriderDataSet,matrix-method}
\alias{normalizationFactors<-,OutriderDataSet,DataFrame-method}
\alias{normalizationFactors<-,OutriderDataSet,NULL-method}
\alias{normalizationFactors<-,OutriderDataSet,data.frame-method}
\title{Accessor functions for the normalization factors in an OutriderDataSet
object.}
\usage{
\S4method{normalizationFactors}{OutriderDataSet}(object, ...)

\S4method{normalizationFactors}{OutriderDataSet,matrix}(object, minE = 0.5, ...) <- value

\S4method{normalizationFactors}{OutriderDataSet,DataFrame}(object, minE = 0.5, ...) <- value

\S4method{normalizationFactors}{OutriderDataSet,data.frame}(object, minE = 0.5, ...) <- value

\S4method{normalizationFactors}{OutriderDataSet,NULL}(object) <- value
}
\arguments{
\item{object}{An \code{\link{OutriderDataSet}} object}

\item{...}{Further arguments are passed on to the underlying assay function}

\item{minE}{The minimal expected count, defaults to 0.5, to be used in 
computing the expected log geom mean.}

\item{value}{The matrix of normalization factors}
}
\value{
A numeric matrix containing the normalization factors or the 
            OutriderDataSet object with an updated 
            \code{normalizationFactors} assay.
}
\description{
To normalize raw count data normalization factors can be provided as
a matrix. When running \code{\link{controlForConfounders}} the normalization 
factors are stored within the OutriderDataset object. This normalization 
factors are then used to compute the normalized counts.
}
\examples{

ods <- makeExampleOutriderDataSet()

normFactors <- matrix(runif(nrow(ods)*ncol(ods),0.5,1.5),
    ncol=ncol(ods),nrow=nrow(ods))

# the normalization factors matrix should not have 0's in it
# it should have geometric mean near 1 for each row
normFactorsRM <- normFactors / exp(rowMeans(log(normFactors)))
normalizationFactors(ods) <- normFactorsRM
normalizationFactors(ods)[1:10,1:10]

normalizationFactors(ods) <- NULL
ods <- estimateSizeFactors(ods)
normalizationFactors(ods) <- normFactors
all(normalizationFactors(ods) == t(sizeFactors(ods) * t(normFactors)))

}
\seealso{
\code{\link{sizeFactors}} 
         \code{\link[DESeq2]{normalizationFactors}}
}
