% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{makeGRangesFromDataFrameFast}
\alias{makeGRangesFromDataFrameFast}
\title{Faster version (also less safe) of makeGRangesFromDataFrame}
\usage{
makeGRangesFromDataFrameFast(df, keep.extra.columns = TRUE, seqinfo = NULL)
}
\arguments{
\item{df}{a data.frame/data.table with columns minimum 4 columns:
seqnames, start, strand\cr
Additional specific columns are:\cr
- width (if not set, width is set to 1 for all reads)\cr
Additional columns will be assigned as meta columns}

\item{keep.extra.columns}{logical, default TRUE, keep meta cols.}

\item{seqinfo}{Seqinfo object, defaul NULL (created from ranges).
Add to avoid warnings later on differences in seqinfo.}
}
\value{
GRanges object
}
\description{
Faster version (also less safe) of makeGRangesFromDataFrame
}
\examples{
df <- data.frame(start = rep(1L, 1e5), end = 10L, strand = "+", seqnames = "1")

system.time(res <- makeGRangesFromDataFrame(df))
system.time(res_fast <- makeGRangesFromDataFrameFast(df))
identical(res, res_fast)

# Use width instead of end, does not work in original
df2 <- data.frame(start = rep(1L, 1e5), width = 10L, strand = "+", seqnames = "1")
system.time(makeGRangesFromDataFrameFast(df2))
df_small <- data.frame(start = 1L, end = 10L, strand = "+", seqnames = "1")
system.time(res <- makeGRangesFromDataFrame(df_small))
system.time(res_fast <- makeGRangesFromDataFrameFast(df_small))
identical(res, res_fast)
}
