% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_plots.R
\name{experiment.colors}
\alias{experiment.colors}
\title{Decide color for libraries by grouping}
\usage{
experiment.colors(
  df,
  color_list = "default",
  skip.libtype = FALSE,
  skip.stage = TRUE,
  skip.replicate = TRUE,
  skip.fraction = TRUE,
  skip.condition = TRUE
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{color_list}{a character vector of colors, default "default".
That is the vector c("skyblue4", 'orange', "green", "red", "gray",
 "yellow", "blue", "red2", "orange3"). Picks number of colors needed to
 make groupings have unique color}

\item{skip.libtype}{a logical (FALSE), don't include libtype}

\item{skip.stage}{a logical (FALSE), don't include stage
in variable name.}

\item{skip.replicate}{a logical (FALSE), don't include replicate
in variable name.}

\item{skip.fraction}{a logical (FALSE), don't include fraction}

\item{skip.condition}{a logical (FALSE), don't include condition
in variable name.}
}
\value{
a character vector of colors
}
\description{
Pick the grouping wanted for colors, by default only group by libtype.
Like RNA-seq(skyblue4) and Ribo-seq(orange).
}
