% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_collapse.R
\name{collapseDuplicatedReads,GAlignmentPairs-method}
\alias{collapseDuplicatedReads,GAlignmentPairs-method}
\title{Collapse duplicated reads}
\usage{
\S4method{collapseDuplicatedReads}{GAlignmentPairs}(x, addScoreColumn = TRUE)
}
\arguments{
\item{x}{a GRanges, GAlignments or GAlignmentPairs object}

\item{addScoreColumn}{logical, default: (TRUE), if FALSE,
only collapse and not keep score column of counts for collapsed reads.
Returns directly without collapsing if reuse.score.column is FALSE and
score is already defined.}
}
\value{
a GRanges, GAlignments, GAlignmentPairs or data.table object,
 same as input
}
\description{
For every GRanges, GAlignments read, with the same:
seqname, start, (cigar) / width and strand, collapse and give a new
meta column called "score", which contains the number of duplicates
of that read. If score column already exists, will return input object!
}
\examples{
gr <- rep(GRanges("chr1", 1:10,"+"), 2)
collapseDuplicatedReads(gr)
}
