% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STAR_multiQC.R
\name{STAR.allsteps.multiQC}
\alias{STAR.allsteps.multiQC}
\title{Create STAR multiQC plot and table}
\usage{
STAR.allsteps.multiQC(
  folder,
  steps = "auto",
  plot.ext = ".pdf",
  output.file = file.path(folder, "full_process.csv")
)
}
\arguments{
\item{folder}{path to main output folder of STAR run. The folder that contains
/aligned/, "/trim/, "contaminants_depletion" etc. To find the LOGS folders in, to
use for summarized statistics.}

\item{steps}{a character, default "auto". Find which steps you did.
If manual, a combination of "tr-co-ge". See STAR alignment functions for description.}

\item{plot.ext}{character, default ".pdf". Which format to save QC plot.
Alternative: ".png".}

\item{output.file}{character, file path, default:
file.path(folder, "full_process.csv")}
}
\value{
data.table of main statistics, plots and data saved to disc. Named:
"/00_STAR_LOG_plot.pdf" and "/00_STAR_LOG_table.csv"
}
\description{
Takes a folder with multiple Log.final.out files
from STAR, and create a multiQC report. This is automatically run with
STAR.align.folder function.
}
\examples{
process_dir <- system.file("extdata/test_processing/", package = "ORFik")
STAR.allsteps.multiQC(process_dir)
STAR.allsteps.multiQC(process_dir, steps = "tr-ge")
}
\seealso{
Other STAR: 
\code{\link{STAR.align.folder}()},
\code{\link{STAR.align.single}()},
\code{\link{STAR.index}()},
\code{\link{STAR.install}()},
\code{\link{STAR.multiQC}()},
\code{\link{STAR.remove.crashed.genome}()},
\code{\link{getGenomeAndAnnotation}()},
\code{\link{install.fastp}()}
}
\concept{STAR}
