% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riboseq_features.R
\name{startRegionCoverage}
\alias{startRegionCoverage}
\title{Start region coverage}
\usage{
startRegionCoverage(
  grl,
  RFP,
  tx = NULL,
  is.sorted = TRUE,
  upstream = 2L,
  downstream = 2L,
  weight = 1L
)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} object
with usually either leaders, cds', 3' utrs or ORFs}

\item{RFP}{ribo seq reads as GAlignments, GRanges or GRangesList object}

\item{tx}{default NULL, a GRangesList of transcripts or (container region),
names of tx must contain all grl names. The names of grl can also be the
ORFik orf names. that is "txName_id"}

\item{is.sorted}{logical (TRUE), is grl sorted.}

\item{upstream}{an integer (2), relative region to get upstream from.}

\item{downstream}{an integer (2), relative region to get downstream from}

\item{weight}{a numeric/integer vector or metacolumn name.
(default: 1L, no differential weighting).
If weight is name of defined meta column in reads object,
it gives the number of times a read was found at that position.
GRanges("chr1", 1, "+", score = 5), would mean "score" column tells
that this alignment region was found 5 times.
if 1L it means each read is weighted equal as 1,
this is what among others countOverlaps() presumes,
if single number (!= 1), it repeats for all ranges,
if vector with length > 1, it must be equal size of the
reads object.}
}
\value{
a numeric vector of counts
}
\description{
Get the number of reads in the start region of each ORF. If you want the
start codon coverage only, set upstream = 0. Standard is 2 upstream
and 2 downstream, a width 5 window centered at start site. since
p-shifting is not 100% accurate, this window is usually the reads from the
start site.
}
\details{
If tx is null, then upstream will be force to 0 and downstream to
a maximum of grl width. Since there is no reference for splicing.
}
\examples{
ORF <- GRanges(seqnames = "1",
               ranges = IRanges(21, 40),
               strand = "+")
names(ORF) <- c("tx1")
grl <- GRangesList(tx1 = ORF)
tx <- extendLeaders(grl, 20)
# 1 width p-shifted reads
reads <- GRanges("1", IRanges(c(21, 23, 50, 50, 50, 53, 53, 56, 59),
                            width = 1), "+")
score(reads) <- 28 # original width
startRegionCoverage(grl, reads, tx)
}
\seealso{
Other features: 
\code{\link{computeFeatures}()},
\code{\link{computeFeaturesCage}()},
\code{\link{countOverlapsW}()},
\code{\link{disengagementScore}()},
\code{\link{distToCds}()},
\code{\link{distToTSS}()},
\code{\link{entropy}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fpkm_calc}()},
\code{\link{fractionLength}()},
\code{\link{initiationScore}()},
\code{\link{insideOutsideORF}()},
\code{\link{isInFrame}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeReleaseScore}()},
\code{\link{ribosomeStallingScore}()},
\code{\link{startRegion}()},
\code{\link{stopRegion}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
