% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment.R
\name{outputLibs}
\alias{outputLibs}
\title{Output NGS libraries to R as variables}
\usage{
outputLibs(
  df,
  type = "default",
  paths = filepath(df, type, only_unique_mappers = only_unique_mappers),
  param = NULL,
  strandMode = 0,
  naming = "minimum",
  library.names = name_decider(df, naming),
  output.mode = "envir",
  chrStyle = NULL,
  envir = envExp(df),
  verbose = TRUE,
  force = TRUE,
  validate_libs = TRUE,
  only_unique_mappers = uniqueMappers(df),
  BPPARAM = bpparam()
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{type}{a character(default: "default"), load files in experiment
or some precomputed variant, like "ofst" or "pshifted".
These are made with ORFik:::convertLibs(),
shiftFootprintsByExperiment(), etc.
Can also be custom user made folders inside the experiments bam folder.
It acts in a recursive manner with priority: If you state "pshifted",
but it does not exist, it checks "ofst". If no .ofst files, it uses
"default", which always must exists.\cr Presets are (folder is relative
to default lib folder, some types fall back to other formats if folder does not exist):\cr
- "default": load the original files for experiment, usually bam.\cr
- "ofst": loads ofst files from the ofst folder, relative to lib folder (falls back to default)\cr
- "pshifted": loads ofst, wig or bigwig from pshifted folder (falls back to ofst, then default)\cr
- "cov": Load covRle objects from cov_RLE folder (fail if not found)\cr
- "covl": Load covRleList objects, from cov_RLE_List folder (fail if not found)\cr
- "bed": Load bed files, from bed folder (falls back to default)\cr
- Other formats must be loaded directly with fimport}

\item{paths}{character vector, the filpaths to use,
default \code{filepath(df, type, only_unique_mappers = only_unique_mappers)}.
Change type argument if not what is wanted.
If that is not enough, then you can also update this argument.
But be careful about using this directly.}

\item{param}{\code{NULL} or a \link[Rsamtools]{ScanBamParam} object.
    Like for \code{\link[Rsamtools]{scanBam}}, this influences what fields
    and which records are imported. However, note that the fields specified
    thru this \link[Rsamtools]{ScanBamParam} object will be loaded
    \emph{in addition} to any field required for generating the returned
    object (\link[GenomicAlignments]{GAlignments}, \link[GenomicAlignments]{GAlignmentPairs},
    or \link[GenomicAlignments]{GappedReads} object),
    but only the fields requested by the user will actually be kept as
    metadata columns of the object.

    By default (i.e. \code{param=NULL} or \code{param=ScanBamParam()}), no 
    additional field is loaded. The flag used is 
    \code{scanBamFlag(isUnmappedQuery=FALSE)} for
    \code{readGAlignments}, \code{readGAlignmentsList}, and
    \code{readGappedReads}.
    (i.e. only records corresponding to mapped reads are loaded),
    and \code{scanBamFlag(isUnmappedQuery=FALSE, isPaired=TRUE,
    hasUnmappedMate=FALSE)} for \code{readGAlignmentPairs}
    (i.e. only records corresponding to paired-end reads with both ends
    mapped are loaded).
  }

\item{strandMode}{numeric, default 0. Only used for paired end bam files.
One of (0: strand = *, 1: first read of pair is +, 2: first read of pair is -).
See ?strandMode. Note: Sets default to 0 instead of 1, as readGAlignmentPairs uses 1.
This is to guarantee hits, but will also make mismatches of overlapping
transcripts in opposite directions.}

\item{naming}{a character (default: "minimum"). Name files as minimum
information needed to make all files unique. Set to "full" to get full
names. Set to "fullexp", to get full name with experiment name as prefix,
the last one guarantees uniqueness.}

\item{library.names}{character vector, names of libraries, default:
name_decider(df, naming)}

\item{output.mode}{character, default "envir". Output libraries to environment.
Alternative: "list", return as list. "envirlist", output to envir and return
as list. If output is list format, the list elements are named from:
\code{bamVarName(df.rfp)} (Full or minimum naming based on 'naming' argument)}

\item{chrStyle}{a GRanges object, TxDb, FaFile,
, a \code{\link{seqlevelsStyle}} or \code{\link{Seqinfo}}.
(Default: NULL) to get seqlevelsStyle from. In addition if it
is a Seqinfo object, seqinfo will be updated.
Example of seqlevelsStyle update:
Is chromosome 1 called chr1 or 1,
 is mitocondrial chromosome called MT or chrM etc.
Will use 1st seqlevel-style if more are present.
Like: c("NCBI", "UCSC") -> pick "NCBI"}

\item{envir}{environment to save to, default
\code{envExp(df)}, which defaults to .GlobalEnv, but can be set with
\code{envExp(df) <- new.env()} etc.}

\item{verbose}{logical, default TRUE, message about library output status.}

\item{force}{logical, default TRUE If TRUE, reload library files even if
matching named variables are found in environment used by experiment
 (see \code{\link{envExp}}) A simple way to make
sure correct libraries are always loaded. FALSE is faster if data
is loaded correctly already.}

\item{validate_libs}{logical, default TRUE. If FALSE, don't check that default
files exists (i.e. bam files), useful if you are using pshifted ofst etc
and don't have the bams anymore.}

\item{only_unique_mappers}{logical, default \code{uniqueMappers(df)}.
Load file of only unique format type, located in './unique_mappers' relative
to bam files / default files. See ?uniqueMappers for more information.}

\item{BPPARAM}{how many cores/threads to use? default: bpparam().
To see number of threads used, do \code{bpparam()$workers}.
You can also add a time remaining bar, for a more detailed pipeline.}
}
\value{
NULL (libraries set by envir assignment), unless output.mode is
"list" or "envirlist": Then you get a list of the libraries. The library
objects will have 3 additional attributes, "exp", "filepath"
and "short_name".
}
\description{
By default loads the original files of the experiment into
the global environment, named by the rows of the experiment
required to make all libraries have unique names.\cr
Uses multiple cores to load, defined by multicoreParam
}
\details{
The functions checks if the total set of libraries have already been loaded:
i.e. Check if all names from 'library.names' exists as S4 objects in
environment of experiment.
}
\examples{
## Load a template ORFik experiment
df <- ORFik.template.experiment()
## Default library type load, usually bam files
outputLibs(df, type = "default")
RFP_WT_r1
attr(RFP_WT_r1, "filepath")
attr(RFP_WT_r1, "exp")
## .ofst file load, if ofst files does not exists
## it will load default
# outputLibs(df, type = "ofst")
## .wig file load, if wiggle files does not exists
## it will load default
# outputLibs(df, type = "wig")
## Load as list
outputLibs(df, output.mode = "list")
## Load libs to new environment (called ORFik in Global)
# outputLibs(df, envir = assign(name(df), new.env(parent = .GlobalEnv)))
## Load to hidden environment given by experiment
# envExp(df) <- new.env()
# outputLibs(df)

}
\seealso{
Other ORFik_experiment: 
\code{\link{ORFik.template.experiment}()},
\code{\link{ORFik.template.experiment.zf}()},
\code{\link{bamVarName}()},
\code{\link{create.experiment}()},
\code{\link{experiment-class}},
\code{\link{filepath}()},
\code{\link{libraryTypes}()},
\code{\link{organism,experiment-method}},
\code{\link{read.experiment}()},
\code{\link{save.experiment}()},
\code{\link{validateExperiments}()}
}
\concept{ORFik_experiment}
