% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_exports.R
\name{export.fstwig}
\alias{export.fstwig}
\title{Export as fstwig (fastwig) format}
\usage{
export.fstwig(
  x,
  file,
  by.readlength = TRUE,
  by.chromosome = TRUE,
  compress = 50
)
}
\arguments{
\item{x}{A GRangesList, GAlignment GAlignmentPairs with score column
 or coverage RLElist
Will be converted to 5' end position of original range. If score column
does not exist, will group ranges and give replicates as score column.}

\item{file}{a character path to valid output file name}

\item{by.readlength}{logical, default TRUE}

\item{by.chromosome}{logical, default TRUE}

\item{compress}{value in the range 0 to 100, indicating the amount of compression to use.
Lower values mean larger file sizes. The default compression is set to 50.}
}
\value{
invisible(NULL) (File is saved as 2 .fstwig files)
}
\description{
Will create 2 files, 1 for + strand (*_forward.fstwig)
and 1 for - strand (*_reverse.fstwig). If all
ranges are * stranded, will output 1 file.
}
\examples{
x <- c(GRanges("1", c(1,3,5), "-"), GRanges("1", c(1,3,5), "+"))
x$size <- rep(c(28, 29), length.out = length(x))
x$score <- c(5,1,2,5,1,6)
seqlengths(x) <- 5
# export.fstwig(x, "~/Desktop/ribo")
}
\references{
"TODO"
}
\seealso{
Other utils: 
\code{\link{bedToGR}()},
\code{\link{convertToOneBasedRanges}()},
\code{\link{export.bed12}()},
\code{\link{export.bigWig}()},
\code{\link{export.wiggle}()},
\code{\link{fimport}()},
\code{\link{findFa}()},
\code{\link{fread.bed}()},
\code{\link{optimizeReads}()},
\code{\link{readBam}()},
\code{\link{readBigWig}()},
\code{\link{readWig}()}
}
\concept{utils}
