% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictORFs.r
\name{predictORF}
\alias{predictORF}
\title{Predict the true ORFs in mRNA molecules}
\usage{
predictORF(
  tr,
  genome = "BSgenome.Hsapiens.UCSC.hg38",
  model = NULL,
  prThr = 0.5,
  workDir = NULL
)
}
\arguments{
\item{tr}{character string giving the name of file with experimental
transcripts. Allowed file formats are "fasta", "fa", "gtf" or "gff".}

\item{genome}{character string giving the name of BSgenome data package with
full genome sequences. Default value is "BSgenome.Hsapiens.UCSC.hg38".}

\item{model}{character string giving the connection or full path to the file
from which the classification model is read. Use default NULL value to 
use our default model.}

\item{prThr}{probability threshold for the "winning" class of ORFs.
Default value is 0.5.}

\item{workDir}{character string giving the path to and name of work
directory. NULL by default that mean the current working directory.}
}
\value{
The coordinates of ORFs in mRNA molecules of interest.
}
\description{
Predict the true ORFs in mRNA molecules.
}
\examples{
\dontrun{
tr_path <- system.file("extdata",
                       "Set.trans_sequences.fasta",
                       package="ORFhunteR")
model <- "http://www.sstcenter.com/download/ORFhunteR/classRFmodel_1.rds"
ORFs <- predictORF(tr=tr_path, model=model)
}
}
\author{
Mikalai M. Yatskou
}
