\name{fdr.spatial2}
\alias{fdr.spatial2} 
\title{Assessment of the significance of spatial bias}	
\description{This function assesses the significance of spatial bias by a one-sided random permutation test.  This is 
achieved by comparing the observed average values of logged fold-changes within a spot's spatial neighbourhood
with an empirical distribution generated by random permutation. The significance of spatial bias is given
by the false discovery rate.}
\usage{fdr.spatial2(object,delta=2,N=100,av="median",edgeNA=FALSE)}
\arguments{\item{object}{object of class marrayRaw or marrayNorm}
             \item{delta}{integer determining the size of spot neighbourhoods 
            (\code{(2*delta+1)x(2*delta+1)}).}
           \item{N}{number of random permutations performed for generation of empirical background distribution}
            \item{av}{averaging of \code{M} within neighbourhood by 
            \emph{mean} or \emph{median} (default)}      
           \item{edgeNA}{treatment of edges of array: For \code{edgeNA=TRUE},
               the significance of a neighbourhood (defined by a sliding window) is set to NA, 
               if the neighbourhood extends over the edges of the matrix.} 
}
\details{ The function \code{fdr.spatial2.Rd} is basically the same as  \code{fdr.spatial},
          but differs in its input and output formats. 
           Details about the functionality  can be found
          at  \code{\link{fdr.spatial}}.}


\value{Two list of vectors containing the false discovery rates for positive (\code{FDRp}) 
        and negative (\code{FDRn}) deviations of
       \eqn{\bar{M}}{median/mean of \code{M}} of the spot's neighbourhood is produced. Each
        vector contains the false discovery values for one array.}
\note{This function will be fused with \code{fdr.spatial} in future versions using S4-style methods.} 
\author{Matthias E. Futschik (\url{http://itb.biologie.hu-berlin.de/~futschik})}
\seealso{ \code{\link{p.spatial}}, \code{\link{fdr.int}}, \code{\link{sigxy.plot}},}

\examples{

# To run these examples, delete the comment signs before the commands.
#
# LOADING DATA
# data(sw)
#
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS
# For this illustration, N was chosen rather small. For "real" analysis, it should be larger.
# FDR <- fdr.spatial2(sw,delta=2,N=10,av="median",edgeNA=TRUE)
#
# SIGNIFICANCE PLOTS OF ARRAY 1
# sigxy.plot2(sw[,1],FDR$FDRp[[1]],FDR$FDRn[[1]],color.lim=c(-5,5),main="FDR")
# SIGNIFICANCE PLOTS OF ARRAY 3
# sigxy.plot2(sw[,3],FDR$FDRp[[3]],FDR$FDRn[[3]],color.lim=c(-5,5),main="FDR")
#
}



\keyword{nonparametric}
\keyword{univar}
\keyword{htest}




