% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalyzerResults.R
\name{performNormalizations}
\alias{performNormalizations}
\alias{performNormalizations,NormalyzerResults-method}
\title{Main function for executing normalizations}
\usage{
performNormalizations(
  nr,
  forceAll = FALSE,
  rtNorm = FALSE,
  rtStepSizeMinutes = 1,
  rtWindowMinCount = 100,
  rtWindowShifts = 1,
  rtWindowMergeMethod = "median",
  noLogTransform = FALSE,
  quiet = FALSE
)

\S4method{performNormalizations}{NormalyzerResults}(
  nr,
  forceAll = FALSE,
  rtNorm = FALSE,
  rtStepSizeMinutes = 1,
  rtWindowMinCount = 100,
  rtWindowShifts = 1,
  rtWindowMergeMethod = "median",
  noLogTransform = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{nr}{Normalyzer results object.}

\item{forceAll}{Ignore dataset size limits and run all normalizations
(only meant for testing purposes)}

\item{rtNorm}{Perform retention time based normalizations}

\item{rtStepSizeMinutes}{Retention time normalization window size.}

\item{rtWindowMinCount}{Minimum number of datapoints in each retention-time
segment.}

\item{rtWindowShifts}{Number of layered retention time normalized windows.}

\item{rtWindowMergeMethod}{Merge approach for layered retention time windows.}

\item{noLogTransform}{Prevent log-transforming input}

\item{quiet}{Don't show regular output messages}
}
\value{
nr NormalyzerDE results object
}
\description{
Main function for executing normalizations
}
\keyword{internal}
