% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/helper_methods.R
\name{newloglik}
\alias{newloglik}
\alias{newloglik,newmodel,matrix-method}
\title{Compute the log-likelihood of a model given some data}
\usage{
newloglik(model, x, ...)

\S4method{newloglik}{newmodel,matrix}(model, x)
}
\arguments{
\item{model}{an object that describes a statistical model.}

\item{x}{an object that describes data.}

\item{...}{additional arguments.}
}
\value{
The log-likelihood of the model given the data.
}
\description{
Given a statistical model and some data, this function computes the
log-likelihood of the model given the data, i.e., the log-probability of the
data under the model.
}
\section{Methods (by class)}{
\itemize{
\item \code{model = newmodel,x = matrix}: return the log-likelihood of the nb model.
}}

\examples{
m <- newmodel(n=5, J=10)
x <- newSim(m)
newloglik(m, x$counts)
}
