% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mds.R
\name{plot_mds}
\alias{plot_mds}
\title{Plot MDS}
\usage{
plot_mds(
  x,
  top = 500,
  plot_dims = c(1, 2),
  labels = colnames(x),
  groups = NULL,
  legend_name = "group"
)
}
\arguments{
\item{x}{a numeric matrix of log-methylation-ratio values where rows are genomic regions/features and columns
are samples.}

\item{top}{the number of top variable features (genes/regions) used to calculate
pairwise distances between samples.}

\item{plot_dims}{the numeric vector of the two dimensions to be plotted
(default c(1, 2) for first two principal coordinates).}

\item{labels}{the character vector of labels for data points. By default uses
column names of x, set to NULL to plot unlabeled points.}

\item{groups}{the character vector or numeric vector of groups that data points
will be coloured by. For character vectors, discrete colours are used. For
numeric vectors, continuous colour scale is used. By default, groups is NULL
and points are not coloured.}

\item{legend_name}{the name for the colour legend.}
}
\value{
ggplot object of the MDS plot.
}
\description{
Plot multi-dimensional scaling plot using algorithm of limma::plotMDS(). It is recommended this be done with the
log-methylation-ratio matrix generated by bsseq_to_log_methy_ratio().
}
\details{
Multi-dimensional scaling (MDS) is a dimensionality reduction technique that
represents high-dimensional distances between samples in a lower-dimensional
space (typically 2D). This function uses limma's plotMDS algorithm, which
selects the most variable features and calculates leading log-fold-change
distances between samples. The resulting plot shows samples as points where
proximity indicates similarity in methylation profiles. When variance explained
is available, it is shown as percentages on the axis labels.
}
\examples{
nmr <- load_example_nanomethresult()
bss <- methy_to_bsseq(nmr)
lmr <- bsseq_to_log_methy_ratio(bss)
plot_mds(lmr)

}
