% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsseq_to_edger.R
\name{bsseq_to_log_methy_ratio}
\alias{bsseq_to_log_methy_ratio}
\title{Convert BSseq object to log-methylation-ratio matrix}
\usage{
bsseq_to_log_methy_ratio(
  bsseq,
  regions = NULL,
  prior_count = 2,
  drop_na = TRUE
)
}
\arguments{
\item{bsseq}{the BSseq object.}

\item{regions}{the regions to calculate log-methylation ratios over. If left NULL, ratios will be calculated per
site.}

\item{prior_count}{the prior count added to avoid taking log of 0.}

\item{drop_na}{whether to drop rows with all NA values.}
}
\value{
a matrix containing log-methylation-ratios.
}
\description{
Creates a log-methylation-ratio matrix from a BSseq object that is useful for
dimensionality reduction plots.
}
\examples{
nmr <- load_example_nanomethresult()
bsseq <- methy_to_bsseq(nmr)
regions <- exons_to_genes(NanoMethViz::exons(nmr))
log_m_ratio <- bsseq_to_log_methy_ratio(bsseq, regions)
}
