% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_reference_fasta.R
\name{write_reference_fasta}
\alias{write_reference_fasta}
\title{Write FASTA file of reference sequences.}
\usage{
write_reference_fasta(regions_gr, output_path = NULL)
}
\arguments{
\item{regions_gr}{A GRanges object including the sequences of the reference
regions included for the data. This can be generated from the \code{get_seq}
function.}

\item{output_path}{The directory where the FASTA file should be written.
Default is NULL, which will write the file to the current working directory.}
}
\value{
Writes a FASTA reference file "reference_output.fasta".
If multiple ranges are included in the GRanges object, the sequences will be
written to a single FASTA file. Sequences names will be the seqnames
(contig) of the range.
}
\description{
Write FASTA file of reference sequences.
}
\details{
Generate an arbitrary multi-sequence FASTA file from GRanges
including the reference sequences.
}
\examples{
# Write FASTA files for the 20 genomic target sequences
# of TwinStrand's Mouse Mutagenesis Panel.
output_path <- tempdir()
rg <- get_seq("TSpanel_mouse")
write_reference_fasta(rg, output_path = output_path)
}
