% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bubbles.R
\name{plot_bubbles}
\alias{plot_bubbles}
\title{Generate Bubble Plots}
\usage{
plot_bubbles(
  mutation_data,
  size_by = "alt_depth",
  facet_col = NULL,
  color_by = "normalized_subtype",
  circle_spacing = 1,
  circle_outline = "none",
  circle_resolution = 50,
  custom_palette = NULL
)
}
\arguments{
\item{mutation_data}{Data frame containing the mutation data.}

\item{size_by}{The column name by which to size the circles.
Recommended values are "alt_depth" or "vaf".}

\item{facet_col}{The column name by which to facet .
If NULL, no facetting will be done. Default is NULL.}

\item{color_by}{The column name by which to colour the mutations. Default is
"normalized_subtype".}

\item{circle_spacing}{Numerical value to adjust the spacing between circles.
Default is 1.}

\item{circle_outline}{Colour for the circle outline. Default is "none",
resulting in no outline colour. Other accepted values are colours in the R
language.}

\item{circle_resolution}{Number of points to use for the circle resolution.
Default is 50.}

\item{custom_palette}{A named vector of colors to be used for the mutation
subtypes. The names of the vector should correspond to the levels in
color_by. Alternatively, you can specify a color palette from the
RColorBrewer package. See \code{\link[RColorBrewer]{brewer.pal}} for palette
options. You may visualize the palettes at the ColorBrewer website:
\url{https://colorbrewer2.org/}. Default is \code{NULL}.}
}
\value{
A ggplot object with the bubble plot, facetted if specified.
}
\description{
Produces a ggplot object of bubble plots from given mutation data.
Optionally, bubble plots can be facetted and
coloured by a specified column.
}
\details{
The function will plot a circle for each mutation in
\code{mutation_data}. Mutations flagged by the \code{filter_mut} column will be
excluded from the plot. The size of the circle is determined by the
\code{size_by} parameter. Sizing by the "alt_depth" or the "vaf" will give users
the ability to visualize the the distribution of recurrent mutations within
their data with large multiplets having a large circle.
}
\examples{
# The example data is a subset of variants from the target chr1
# from samples of the high dose group (50mg).
example_data <- readRDS(system.file("extdata", "Example_files",
                                    "variants_subset_d50_chr1.rds",
                                     package = "MutSeqR")
)
 plot <- plot_bubbles(
    mutation_data = example_data
  )

}
