% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_regions_file.R
\name{load_regions_file}
\alias{load_regions_file}
\title{Imports the regions file}
\usage{
load_regions_file(regions, rg_sep = "\\t", is_0_based_rg = TRUE)
}
\arguments{
\item{regions}{The regions metadata file to import. Can be either a file
path, a data frame, or a GRanges object. File paths will be read using
the rg_sep. Users can also choose from the built-in TwinStrand's Mutagenesis
Panels by inputting "TSpanel_human",  "TSpanel_mouse", or "TSpanel_rat".
Required columns for the regions file are "contig", "start", and "end".
In a GRanges object, the required columns are "seqnames", "start", and "end".}

\item{rg_sep}{The delimiter for importing the custom_regions. The default is
tab-delimited "\\t".}

\item{is_0_based_rg}{A logical variable. Indicates whether the position
coordinates in \code{regions} are 0 based (TRUE) or 1 based (FALSE).
If TRUE, positions will be converted to 1-based (start + 1).
Need not be supplied for TSpanels. Default is TRUE.}
}
\value{
a GRanges object of the imported regions metadata file.
}
\description{
A helper function to import the regions metadata file and
return a GRanges object.
}
\examples{
#' # Example 1: Load built-in TwinStrand's Human Mutagenesis
human_rg <- load_regions_file(regions = "TSpanel_human")
human_rg
# Load a custom regions file from an interval list
# We will use the human TSpanel system file for this example,
# but any file can be imported.
file <- system.file("extdata",
  "inputs",
  "metadata",
  "human_mutagenesis_panel_hg38.txt",
  package = "MutSeqR"
)
custom_rg <- load_regions_file(regions = file, rg_sep = "\t", is_0_based_rg = TRUE)
custom_rg
}
