% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_helpers.R
\name{check_required_columns}
\alias{check_required_columns}
\title{Check that all required columns are present before proceeding with the function}
\usage{
check_required_columns(data, required_columns)
}
\arguments{
\item{data}{mutation data}

\item{required_columns}{a list of required column names.}
}
\value{
an error
}
\description{
A utility function that will check that all required columns are present.
}
\examples{
df <- data.frame(
  contig = c("chr1", "chr2", "chr3"),
  start = c(100, 200, 300),
  end = c(100, 200, 300),
  sample = c("S1", "S2", "S3"),
  ref = c("G", "C", "T"),
  alt = c("A", "T", "G")
)
check_required_columns(df, required_columns = op$base_required_mut_cols)
}
