% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_range_pval.R
\name{check_range_p_val}
\alias{check_range_p_val}
\title{Ensure that the p values are not >1 and if so set to 1}
\source{
\code{
sumstats_dt <- MungeSumstats:::formatted_example()
sumstats_dt$P[1:3] <- 5
sumstats_dt$P[6:10] <- -5
sumstats <- check_range_p_val(sumstats_dt = sumstats_dt, 
                              convert_large_p = TRUE,
                              convert_neg_p = TRUE, 
                              imputation_ind = TRUE)
}
}
\usage{
check_range_p_val(sumstats_dt, convert_large_p, convert_neg_p, imputation_ind)
}
\arguments{
\item{sumstats_dt}{data table obj of the summary statistics file for the GWAS}

\item{convert_large_p}{Binary, should p-values >1 be converted to 1?
P-values >1 should not be possible and can cause errors with LDSC/MAGMA and
should be converted. Default is TRUE.}

\item{convert_neg_p}{Binary, should p-values <0 be converted to 0?
Negative p-values should not be possible and can cause errors
with LDSC/MAGMA and should be converted. Default is TRUE.}

\item{imputation_ind}{Binary Should a column be added for each imputation
step to show what SNPs have imputed values for differing fields. This
includes a field denoting SNP allele flipping (flipped). On the flipped
value, this denoted whether the alelles where switched based on
MungeSumstats initial choice of A1, A2 from the input column headers and thus
may not align with what the creator intended.\strong{Note} these columns will be
in the formatted summary statistics returned. Default is FALSE.}
}
\value{
list containing sumstats_dt,
the modified summary statistics data table object
}
\description{
Ensure that the p values are not >1 and if so set to 1
}
\keyword{internal}
