% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_vcf_parallel.R
\name{read_vcf_parallel}
\alias{read_vcf_parallel}
\title{Read VCF: parallel}
\source{
\code{
path <- "https://gwas.mrcieu.ac.uk/files/ieu-a-298/ieu-a-298.vcf.gz"
#### Single-threaded ####
vcf <- MungeSumstats:::read_vcf_parallel(path = path)
#### Parallel ####
vcf2 <- MungeSumstats:::read_vcf_parallel(path = path, nThread=11)
}
}
\usage{
read_vcf_parallel(
  path,
  samples = 1,
  which = NULL,
  use_params = TRUE,
  as_datatable = TRUE,
  sampled_rows = 10000L,
  include_xy = FALSE,
  download = TRUE,
  vcf_dir = tempdir(),
  download_method = "download.file",
  force_new = FALSE,
  tilewidth = NULL,
  mt_thresh = 100000L,
  nThread = 1,
  ntile = nThread,
  verbose = TRUE
)
}
\arguments{
\item{path}{Path to local or remote VCF file.}

\item{samples}{Which samples to use:
\itemize{
\item{1 : }{Only the first sample will be used (\emph{DEFAULT}).}
\item{NULL : }{All samples will be used.}
\item{c("<sample_id1>","<sample_id2>",...) : }{
Only user-selected samples will be used (case-insensitive).}
}}

\item{which}{Genomic ranges to be added if supplied. Default is NULL.}

\item{use_params}{When \code{TRUE} (default), increases the speed of reading in the VCF by
omitting columns that are empty based on the head of the VCF (NAs only).
NOTE that that this requires the VCF to be sorted, bgzip-compressed,
tabix-indexed, which \link[MungeSumstats]{read_vcf} will attempt to do.}

\item{as_datatable}{Return the data as a
\link[data.table]{data.table} (default: \code{TRUE})
or a \link[VariantAnnotation]{VCF} (\code{FALSE}).}

\item{sampled_rows}{First N rows to sample.
Set \code{NULL} to use full \code{sumstats_file}.
when determining whether cols are empty.}

\item{download}{Download the VCF (and its index file)
to a temp folder before reading it into R.
This is important to keep \code{TRUE} when \code{nThread>1} to avoid
making too many queries to remote file.}

\item{vcf_dir}{Where to download the original VCF from Open GWAS.
\emph{WARNING:} This is set to \code{tempdir()} by default.
This means the raw (pre-formatted) VCFs be deleted upon ending the R session.
Change this to keep the raw VCF file on disk
(e.g. \code{vcf_dir="./raw_vcf"}).}

\item{download_method}{\code{"axel"} (multi-threaded) or
\code{"download.file"} (single-threaded) .}

\item{force_new}{If a formatted file of the same names as \code{save_path}
exists, formatting will be skipped and this file will be imported instead
(default). Set \code{force_new=TRUE} to override this.}

\item{tilewidth}{
    The desired tile width. The effective tile width might be slightly
    different but is guaranteed to never be more than the desired width.
  }

\item{mt_thresh}{When the number of rows (variants) in the VCF is
\code{< mt_thresh}, only use single-threading for reading in the VCF.
This is because the overhead of parallelisation outweighs the speed benefits
when VCFs are small.}

\item{nThread}{Number of threads to use for parallel processes.}

\item{ntile}{
    The number of tiles to generate.
  }

\item{verbose}{Print messages.}
}
\value{
VCF file.
}
\description{
Read a VCF file across 1 or more threads in parallel.
If \code{tilewidth} is not specified, the size of each chunk will be
determined by total genome size divided by \code{ntile}.
By default, \code{ntile} is equal to the number of threads, \code{nThread}.
For further discussion on how this function was optimised,
see
\href{https://github.com/Bioconductor/VariantAnnotation/issues/59}{here}
and
\href{https://github.com/Bioconductor/VariantAnnotation/issues/57}{here}.
}
\keyword{internal}
