% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_frq.R
\name{check_frq}
\alias{check_frq}
\title{Ensure all SNPs have frq score above threshold}
\usage{
check_frq(
  sumstats_dt,
  path,
  FRQ_filter,
  log_folder_ind,
  check_save_out,
  tabix_index,
  nThread,
  log_files
)
}
\arguments{
\item{path}{Filepath for the summary statistics file to be formatted. A
dataframe or datatable of the summary statistics file can also be passed
directly to MungeSumstats using the path parameter.}

\item{FRQ_filter}{numeric The minimum value permissible of the frequency(FRQ)
of the SNP (i.e. Allele Frequency (AF)) (if present in sumstats file). By
default no filtering is done, i.e. value of 0.}

\item{log_folder_ind}{Binary Should log files be stored containing all
filtered out SNPs (separate file per filter). The data is outputted in the
same format specified for the resulting sumstats file. The only exception to
this rule is if output is vcf, then log file saved as .tsv.gz. Default is
FALSE.}

\item{tabix_index}{Index the formatted summary statistics with
\href{http://www.htslib.org/doc/tabix.html}{tabix} for fast querying.}

\item{nThread}{Number of threads to use for parallel processes.}

\item{log_files}{list of log file locations}
}
\value{
list containing sumstats_dt, the modified summary statistics data
table object and the log file list
}
\description{
Ensure all SNPs have frq score above threshold
}
\keyword{internal}
