% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RawCountsSimulation.R
\name{RawCountsSimulation}
\alias{RawCountsSimulation}
\title{RNA-seq raw counts data simulation}
\usage{
RawCountsSimulation(Nb.Group, Nb.Time, Nb.per.GT, Nb.Gene)
}
\arguments{
\item{Nb.Group}{Non negative integer.
Number of biological condition (minimum 1).}

\item{Nb.Time}{Non negative integer. Number of time points (minimum 1).}

\item{Nb.per.GT}{Non negative integer.
Number of sample for each condition and time (minimum 1).}

\item{Nb.Gene}{Non negative integer. Number of genes (minimum 1)}
}
\value{
A simulated RNA-seq raw counts data.
}
\description{
The function simulates an in silico RNA-seq raw counts data
inspired from the model used in the \code{DESeq2} package.
It is used in some examples of other functions.
}
\examples{
RawCountsSimulation(Nb.Group=3, Nb.Time=5, Nb.per.GT=7, Nb.Gene=50)
## RawCountsSimulation(Nb.Group=1, Nb.Time=5, Nb.per.GT=7, Nb.Gene=50)
## RawCountsSimulation(Nb.Group=3, Nb.Time=1, Nb.per.GT=7, Nb.Gene=50)
}
