% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEanalysisTime.R
\name{DEanalysisTime}
\alias{DEanalysisTime}
\title{DE analysis when samples belong to different time points only.}
\usage{
DEanalysisTime(
  DESeq.result,
  pval.min = 0.05,
  pval.vect.t = NULL,
  log.FC.min = 1,
  LRT.supp.info = FALSE,
  Plot.DE.graph = TRUE,
  path.result = NULL,
  SubFile.name = NULL
)
}
\arguments{
\item{DESeq.result}{Output from the function
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}.}

\item{pval.min}{Numeric value between 0 and 1. A gene will be considered as
differentially expressed (DE) between two biological conditions if
its Benjamini-Hochberg adjusted p-value
(see \code{\link[stats:p.adjust]{stats::p.adjust()}})
is below the threshold pval.min. Default value is 0.05}

\item{pval.vect.t}{\code{NULL} or vector of dimension \eqn{T-1} filled with
numeric values between 0 and 1, with \eqn{T} the number of time
measurements.
A gene will be considered as differentially expressed (DE) between the time
ti and the reference time t0 if its Benjamini-Hochberg adjusted p-value
(see \code{\link[stats:p.adjust]{stats::p.adjust()}})
is below the i-th threshold of \code{pval.vect.t}.
If NULL, \code{pval.vect.t} will be vector of dimension \eqn{T-1} filled
with \code{pval.min}.}

\item{log.FC.min}{Non negative numeric value.
If the \eqn{log_2} fold change between biological conditions or times has
an absolute value below the threshold \code{log.FC.min}, then the gene is
not selected even if is considered as DE. Default value is 1.
If \code{log.FC.min=0}, all DE genes will be kept.}

\item{LRT.supp.info}{\code{TRUE} or \code{FALSE}.
If \code{TRUE}, the algorithm realizes another statistical test in order to
detect if, among all biological conditions and/or times, at least one has
a different behavior than the others (see the input 'test' in
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}).}

\item{Plot.DE.graph}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
If \code{TRUE}, all graphs will be plotted.
Otherwise no graph will be plotted.}

\item{path.result}{Character or \code{NULL}.
If \code{path.result} is a character, it must be a path to a folder,
all graphs will be saved in \code{path.result}.
If \code{NULL}, the results will not be saved in a folder. NULL as default.}

\item{SubFile.name}{Character or \code{NULL}
If \code{SubFile.name} is a character, each saved file names will contain
the strings of characters "_\code{SubFile.name}".
If \code{NULL}, no suffix will be added.}
}
\value{
The function returns the same DESeqDataSet class object
\code{DESeq.result} with the following results,
saved in the metadata \code{DEresultsTime} of \code{DESeq.result}:
\itemize{
\item a data.frame (output \code{DEsummary} of \code{DEresultsTime})
which contains
\itemize{
\item gene names
\item pvalues, log2 fold change and DE genes between each time ti versus the
reference time t0.
\item a binary column (1 and 0) where 1 means the gene is DE at least at
between one time ti versus the reference time t0.
\item a column where each element is succession of 0 and 1.
The positions of '1' indicate the set of times ti such that the gene is
DE between ti and the reference time t0.
}
\item an alluvial graph of differentially expressed (DE) genes
(see \code{\link[=DEplotAlluvial]{DEplotAlluvial()}})
\item a graph showing the number of DE genes as a function of time for each
temporal group
(see \code{\link[=DEplotAlluvial]{DEplotAlluvial()}}).
By temporal group, we mean the sets of genes which are first DE at
the same time.
\item a barplot which gives the number of DE genes per time
(see \code{\link[=DEplotBarplotTime]{DEplotBarplotTime()}})
\item an UpSet plot (Venn diagram displayed as a barplot) which gives the number
of genes per temporal pattern
(see \code{\link[=DEplotVennBarplotTime]{DEplotVennBarplotTime()}}).
By temporal pattern, we mean the set of times ti such that the gene is
DE between ti and the reference time t0.
\item a similar UpSet plot where each bar is split in different colors
corresponding to all possible numbers of DE times where genes are over
expressed in a given temporal pattern.
}
}
\description{
The function realizes from the
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}
output the analysis of DE genes between each time versus
the reference time t0.
}
\examples{
data(RawCounts_Leong2014_FISSIONsub500wt)
## We take only the first three time for the speed of the example
RawCounts_Fission_3t<-RawCounts_Leong2014_FISSIONsub500wt[seq_len(200),
                                                          seq_len(10)]

## Preprocessing step
resDATAprepSEfission <- DATAprepSE(RawCounts=RawCounts_Fission_3t,
                                   Column.gene=1,
                                   Group.position=NULL,
                                   Time.position=2,
                                   Individual.position=3)

DESeq2preprocess <- S4Vectors::metadata(resDATAprepSEfission)$DESeq2obj
DESeq2obj <- DESeq2preprocess$DESeq2preproceesing

##------------------------------------------------------------------------##
dds.DE.T <- DESeq2::DESeq(DESeq2obj, quiet=TRUE, betaPrior=FALSE)
##
res.T <- DEanalysisTime(DESeq.result=dds.DE.T,
                        pval.min=0.05,
                        pval.vect.t=c(0.01,0.05,0.05),
                        log.FC.min=1,
                        LRT.supp.info=FALSE,
                        Plot.DE.graph=TRUE,
                        path.result=NULL,
                        SubFile.name=NULL)
}
\seealso{
The outputs of the function will be used by the main function
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}.
}
