% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEanalysisGroup.R
\name{DEanalysisGroup}
\alias{DEanalysisGroup}
\title{DE Analysis when samples belong to different biological conditions.}
\usage{
DEanalysisGroup(
  DESeq.result,
  pval.min = 0.05,
  log.FC.min = 1,
  LRT.supp.info = TRUE,
  Plot.DE.graph = TRUE,
  path.result = NULL,
  SubFile.name = NULL
)
}
\arguments{
\item{DESeq.result}{Output from the function
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}.}

\item{pval.min}{Numeric value between 0 and 1. A gene will be considered as
differentially expressed (DE) between two biological conditions if
its Benjamini-Hochberg adjusted p-value
(see \code{\link[stats:p.adjust]{stats::p.adjust()}})
is below the threshold \code{pval.min}. Default value is 0.05.}

\item{log.FC.min}{Non negative numeric value.
If the log2 fold change between biological conditions or times has
an absolute value below the threshold \code{log.FC.min}, then the gene is
not selected even if is considered as DE. Default value is 1.
If \code{log.FC.min=0}, all DE genes will be kept.}

\item{LRT.supp.info}{\code{TRUE} or \code{FALSE}.
If \code{TRUE}, the algorithm realizes another statistical test in order
to detect if, among all biological conditions and/or times, at least one
has a different behavior than the others (see the input 'test' in
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}).}

\item{Plot.DE.graph}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
If \code{TRUE}, all graphs will be plotted.
Otherwise no graph will be plotted.}

\item{path.result}{Character or \code{NULL}.
If \code{path.result} is a character, it must be a path to a folder,
all graphs will be saved in \code{path.result}.
If \code{NULL}, the results will not be saved in a folder.
\code{NULL} as default.}

\item{SubFile.name}{Character or \code{NULL}.
If \code{SubFile.name} is a character, each saved file names will contain
the strings of characters "_\code{SubFile.name}".
If \code{NULL}, no suffix will be added.}
}
\value{
The function returns the same DESeqDataSet class object
\code{DESeq.result} with the following results,
saved in the metadata \code{DEresultsGroup} of \code{DESeq.result}:
\itemize{
\item a data.frame (output \code{DEsummary} of \code{DEresultsGroup})
which contains
\itemize{
\item gene names
\item pvalues, log2 fold change and DE genes between each pairs of
biological conditions.
\item a binary column (1 and 0) where 1 means the gene is DE between at
least one pair of biological conditions.
\item \eqn{N_{bc}} binary columns, where \eqn{N_{bc}} is the number of
biological conditions, which gives the specific genes for each
biological condition.
A '1' in one of these columns means the gene is specific to the
biological condition associated to the given column. 0 otherwise.
A gene is called specific to a given biological condition BC1,
if the gene is DE between BC1 and any other biological conditions,
but not DE between any pair of other biological conditions.
\item \eqn{N_{bc}} columns filled with -1, 0 and 1, one per biological
condition. A '1' in one of these columns means the gene is up-regulated
(or over-expressed) for the biological condition associated to the
given column. A gene is called up-regulated for a given biological
condition BC1 if the gene is specific to the biological condition BC1
and expressions in BC1 are higher than in the other
biological conditions.
A '-1' in one of these columns means the gene is down-regulated
(or under-expressed) for the biological condition associated to the
given column.
A gene is called down-regulated for a given biological condition BC1 if
the gene is specific to the biological condition BC1 and expressions in
BC1 are lower than in the other biological conditions.
A '0' in one of these columns means the gene is not specific to the
biological condition associated to the given column.
}
\item A contingency matrix (output \code{Summary.DEanalysis}
of \code{DEresultsGroup}) which gives for each biological condition
the number of genes categorized as
"Upregulated", "DownRugulated" and "Other".
A gene is categorized as 'Other', for a given biological condition,
if the gene is not specific to the given biological condition.
The category 'Other' does not exist when there are only two biological
conditions.
\item an UpSet plot (Venn diagram displayed as a barplot) which gives the
number of genes for each possible intersection
(see \code{\link[=DEplotVennBarplotGroup]{DEplotVennBarplotGroup()}}).
We consider that a set of pairs of biological conditions forms an
intersection if there is at least one gene which is DE for each of
these pairs of biological conditions, but not for the others.
\item a barplot which gives the number of genes categorized as "Upregulated"
and "DownRugulated", per biological condition
(see \code{\link[=DEplotBarplot]{DEplotBarplot()}}).
\item a barplot which gives the number of genes categorized as "Upregulated",
"DownRugulated" and "Other", per biological condition
(see \code{\link[=DEplotBarplot]{DEplotBarplot()}}).
So this barplot, only plotted when there are strictly more than
two biological conditions, is similar to the previous barplot but with
the category "Other".
}
}
\description{
The function realizes from the
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}
output the analysis of DE genes between all pairs of biological conditions.
}
\examples{
## Data
data(RawCounts_Antoszewski2022_MOUSEsub500)
## No time points. We take only two groups for the speed of the example
RawCounts_T1Wt<-RawCounts_Antoszewski2022_MOUSEsub500[seq_len(200),
                                                      seq_len(7)]

## Preprocessing step
resDATAprepSEmus1<- DATAprepSE(RawCounts=RawCounts_T1Wt,
                               Column.gene=1,
                               Group.position=1,
                               Time.position=NULL,
                               Individual.position=2)

DESeq2preprocess <- S4Vectors::metadata(resDATAprepSEmus1)$DESeq2obj
DESeq2obj <- DESeq2preprocess$DESeq2preproceesing

##------------------------------------------------------------------------##
dds.DE.G <- DESeq2::DESeq(DESeq2obj, quiet=TRUE, betaPrior=FALSE)

res.sum.group <- DEanalysisGroup(DESeq.result=dds.DE.G,
                                 pval.min=0.01,
                                 log.FC.min=1,
                                 LRT.supp.info=FALSE,
                                 Plot.DE.graph=TRUE,
                                 path.result=NULL,
                                 SubFile.name=NULL)
}
\seealso{
The outputs of the function are used by the main function
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}.
}
