% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DATAplotExpression1Gene.R
\name{DATAplotExpression1Gene}
\alias{DATAplotExpression1Gene}
\title{Plot expression of one gene.}
\usage{
DATAplotExpression1Gene(
  SEres,
  row.gene = 1,
  Color.Group = NULL,
  ylabel = "Expression"
)
}
\arguments{
\item{SEres}{Results of either our R function
\code{\link[=DATAprepSE]{DATAprepSE()}},
or our R function
\code{\link[=DATAnormalization]{DATAnormalization()}}.}

\item{row.gene}{Non negative integer indicating the row of the gene
to be plotted.}

\item{Color.Group}{NULL or a data.frame with \eqn{N_{bc}} rows and
two columns where \eqn{N_{bc}} is the number of biological conditions.
If \code{Color.Group} is a data.frame, the first column must contain
the name of each biological condition and the second column must contain
the colors associated to each biological condition.
If \code{Color.Group=NULL}, the function will automatically attribute
a color for each biological condition.
If samples belong to different time points only,
\code{Color.Group} will not be used.}

\item{ylabel}{Character corresponding to the label of the y-axis.
By default, \code{ylab="Expression"}.}
}
\value{
The function plots for the gene selected with
the input \code{row.gene}
\itemize{
\item In the case where samples belong to different time points only :
the evolution of the expression of each replicate across time and
the evolution of the mean and the standard deviation of
the expression across time.
\item In the case where samples belong to different biological conditions only:
a violin plot
(see \code{\link[ggplot2:geom_violin]{ggplot2::geom_violin()}}),
and error bars (standard deviation)
(see \code{\link[ggplot2:geom_linerange]{ggplot2::geom_errorbar()}})
for each biological condition.
\item In the case where samples belong to different time points and
different biological conditions : the evolution of the expression of
each replicate across time and the evolution of the mean and
the standard deviation of the expression across time
for each biological condition.
}
}
\description{
The function allows to plot the gene expression profile of
one gene only according to time and/or biological conditions.
}
\details{
All results are built from either the results of our R function
\code{\link[=DATAprepSE]{DATAprepSE()}}
or the results of our R function
\code{\link[=DATAnormalization]{DATAnormalization()}}.
}
\examples{
## Simulation raw counts
resSIMcount <- RawCountsSimulation(Nb.Group=2, Nb.Time=3, Nb.per.GT=4,
                                   Nb.Gene=10)
## Preprocessing step
resDATAprepSE <- DATAprepSE(RawCounts=resSIMcount$Sim.dat,
                            Column.gene=1,
                            Group.position=1,
                            Time.position=2,
                            Individual.position=3)
##------------------------------------------------------------------------##
resEVO1gene <- DATAplotExpression1Gene(SEres=resDATAprepSE,
                                       row.gene=1,
                                       Color.Group=NULL)
print(resEVO1gene)
}
\seealso{
The \code{\link[=DATAplotExpression1Gene]{DATAplotExpression1Gene()}}
function is used by the following function of our package:
\code{\link[=DATAplotExpressionGenes]{DATAplotExpressionGenes()}}.
}
