% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DATAplotBoxplotSamples.R
\name{DATAplotBoxplotSamples}
\alias{DATAplotBoxplotSamples}
\title{Visualization of the distribution of all gene expressions using
a boxplot for each sample.}
\usage{
DATAplotBoxplotSamples(
  SEres,
  Log2.transformation = TRUE,
  Colored.By.Factors = FALSE,
  Color.Group = NULL,
  Plot.genes = FALSE,
  y.label = NULL
)
}
\arguments{
\item{SEres}{Results of the function
\code{\link[=DATAprepSE]{DATAprepSE()}} or
\code{\link[=DATAnormalization]{DATAnormalization()}}.}

\item{Log2.transformation}{\code{TRUE} or \code{FALSE}.
\code{TRUE} by default.
If \code{TRUE}, each numeric value \eqn{x} in \code{ExprData} will become
\eqn{log_2(x+1)} (see \code{Details}).}

\item{Colored.By.Factors}{\code{TRUE} or \code{FALSE}.
\code{FALSE} by default.
If \code{TRUE}, boxplots will be colored with different colors for different
time measurements (if data were collected at different time points).
Otherwise, boxplots will be colored with different colors for
different biological conditions.}

\item{Color.Group}{\code{NULL} or a data.frame with \eqn{N_{bc}} rows and
two columns where \eqn{N_{bc}} is the number of biological conditions.
\code{NULL} by default.
If \code{Color.Group} is a data.frame, the first column must contain
the name of each biological condition and the second column must contain
the colors associated to each biological condition.
If \code{Color.Group=NULL}, the function will automatically attribute a
color for each biological condition.
If samples belong to different time points only,
\code{Color.Group} will not be used.}

\item{Plot.genes}{\code{TRUE} or \code{FALSE}. \code{FALSE} by default.
If \code{TRUE}, points representing gene expression
(normalized or raw counts) will be added for each sample.}

\item{y.label}{\code{NULL} or a character. \code{NULL} by default.
If \code{y.label} is a character, it will be the y label of the graph.
If \code{y.label=NULL}, the label will be either "log2(Gene expression +1)"
(if \code{Log2.transformation=TRUE}) or "Gene expression"
(if \code{Log2.transformation=FALSE}).}
}
\value{
The function returns a graph which plots the distribution of all
gene expressions using a boxplot for each sample
(see \code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}).
}
\description{
From the results of either our R function
\code{\link[=DATAprepSE]{DATAprepSE()}}
or our R function
\code{\link[=DATAnormalization]{DATAnormalization()}}
(raw counts or normalized raw counts),
the function plots the distribution of all gene expressions using
a boxplot for each sample.
}
\details{
The boxplot allows to visualize six summary statistics
(see \code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}):
\itemize{
\item the median
\item two hinges: first and third quartiles denoted Q1 and Q3.
\item two whiskers: \eqn{W1:=Q1-1.5*IQR} and \eqn{W3:=Q3+1.5*IQR}
with \eqn{IQR=Q3-Q1}, the interquartile range.
\item outliers: data beyond the end of the whiskers are called "outlying"
points and are plotted in black.
}

For better visualization of the six summary statistics described above,
raw counts must be transformed using the function \eqn{log_2(x+1)}.
This transformation is automatically performed by other functions of
the package, such as
\code{\link[=DATAnormalization]{DATAnormalization()}}.
\code{Log2.transformation} will be set as TRUE in
\code{\link[=DATAnormalization]{DATAnormalization()}}
if \code{Normalization ="rle"}, otherwise \code{Log2.transformation=FALSE}.
}
\examples{
data(RawCounts_Antoszewski2022_MOUSEsub500)
##------------------------------------------------------------------------##
resDATAprepSE <- DATAprepSE(RawCounts=RawCounts_Antoszewski2022_MOUSEsub500,
                            Column.gene=1,
                            Group.position=1,
                            Time.position=NULL,
                            Individual.position=2)
##------------------------------------------------------------------------##
DATAplotBoxplotSamples(SEres=resDATAprepSE,
                       Log2.transformation=TRUE,
                       Colored.By.Factors=TRUE,
                       Color.Group=NULL,
                       Plot.genes=FALSE,
                       y.label=NULL)
}
\seealso{
The \code{\link[=DATAplotBoxplotSamples]{DATAplotBoxplotSamples()}} function
\itemize{
\item is used by the following function of our package:
\code{\link[=DATAnormalization]{DATAnormalization()}}.
\item calls the R functions
\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot} and
\link[ggplot2:geom_jitter]{ggplot2::geom_jitter}
in order to print the boxplot.
}
}
