% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_MultiDataSet-ClassGenerics.R
\name{commonSamples}
\alias{commonSamples}
\title{Method to select samples that are present in all datasets.}
\usage{
commonSamples(object, unify.names = FALSE)
}
\arguments{
\item{object}{\code{MultiDataSet} that will be filtered.}

\item{unify.names}{Logical indicating if sample names of the sets should be unified.}
}
\value{
A new \code{MultiDataSet} with only the common samples.
}
\description{
This method subsets the datasets to only contain the samples that are in all datasets. All sets 
will have the samples in the same order, taking into account that there can be duplicates.
}
\details{
If unify.names is TRUE, the sample names of the sets will be unified using the id column of 
phenodata. This option is only possible when there are no duplicated ids.
}
\examples{
 
multi <- createMultiDataSet()
eset <- new("ExpressionSet", exprs = matrix(runif(9), ncol = 3))
fData(eset) <- data.frame(chromosome = c("chr1", "chr1", "chr1"), 
                          start = c(1, 5, 10),end = c(4, 6, 14), 
                          stringsAsFactors = FALSE)
sampleNames(eset) <- c("S1", "S2", "S3")
pData(eset) <- data.frame(id = c("S1", "S2", "S3"))
rownames(pData(eset)) <- c("S1", "S2", "S3")
multi <- add_genexp(multi, eset, dataset.name = "g1")
eset <- new("ExpressionSet", exprs = matrix(runif(8), ncol = 2))
fData(eset) <- data.frame(chromosome = c("chr1", "chr1", "chr1", "chr1"), 
                          start = c(1, 14, 25, 104),end = c(11, 16, 28, 115),
                          stringsAsFactors = FALSE)
sampleNames(eset) <- c("S1", "G2")
pData(eset) <- data.frame(id = c("S1", "G2"))
rownames(pData(eset)) <- c("S1", "G2")

multi <- add_genexp(multi, eset, dataset.name="g2")
commonSamples(multi)
}
