% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_MultiDataSet-ClassGenerics.R
\name{add_snps}
\alias{add_snps}
\title{Method to add a slot of SNPs to \code{MultiDataSet}.}
\usage{
add_snps(object, snpSet, ...)
}
\arguments{
\item{object}{\code{MultiDataSet} that will be filled.}

\item{snpSet}{\code{SnpSet} to be used to fill the slot.}

\item{...}{Arguments to be passed to \code{add_eset}.}
}
\value{
A new \code{MultiDataSet} with the slot \code{"snps"}
filled.
}
\description{
This method adds or overwrites the slot \code{"snps"} of an
\code{MultiDataSet} with the content of the given \code{SnpSet}. The fData of the
\code{SnpSet} must contain the columns chromosome and position.
}
\examples{
multi <- createMultiDataSet()
geno <- matrix(c(3,1,2,1), ncol = 2)
colnames(geno) <- c("VAL0156", "VAL0372")
rownames(geno) <- c("rs3115860", "SNP1-1628854")
map <- AnnotatedDataFrame(data.frame(chromosome = c("chr1", "chr2"), position = c(12414, 1234321),
     stringsAsFactors = FALSE))
rownames(map) <- rownames(geno)
snpSet <- new("SnpSet", call = geno, featureData = map)
pheno <- data.frame(id = c("VAL0156", "VAL0372"))
rownames(pheno) <- c("VAL0156", "VAL0372")
pData(snpSet) <- pheno
multi <- add_snps(multi, snpSet)
}
